/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.plandb;

import com.raplix.rolloutexpress.config.ConfigGenException;
import com.raplix.rolloutexpress.config.ConfigGenerator;
import com.raplix.rolloutexpress.config.TargetedConfigContext;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.XMLUtil;
import com.raplix.rolloutexpress.systemmodel.hostdbx.Host;
import com.raplix.rolloutexpress.systemmodel.installdb.InstallDBContext;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponent;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponentID;
import com.raplix.rolloutexpress.systemmodel.plandb.Caller;
import com.raplix.rolloutexpress.systemmodel.plandb.ComponentTargeterBase;
import com.raplix.rolloutexpress.systemmodel.plandb.InstalledComponentTargeter;
import com.raplix.rolloutexpress.systemmodel.plandb.InstalledTarget;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBException;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBTransformer;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBVisitor;
import com.raplix.util.ObjectUtil;
import org.apache.ecs.xml.XML;
import org.w3c.dom.Element;

public class TargetableComponentTargeter
extends ComponentTargeterBase
implements InstalledComponentTargeter {
    public static final String ELEMENT_NAME = "targetableComponent";
    private static final String HOST_ATTR = "host";
    private String mHost;

    public TargetableComponentTargeter(String host) {
        this.setHost(host);
    }

    TargetableComponentTargeter(Element element) {
        this.setHost(XMLUtil.getAttribute(element, HOST_ATTR));
    }

    private TargetableComponentTargeter() {
    }

    public String toString() {
        return this.lookupDesc("pdb.targeter.TARGETABLE_COMPONENT");
    }

    public String getHost() {
        return this.mHost;
    }

    private void setHost(String host) {
        this.mHost = host;
    }

    public InstalledTarget getInstalledTarget(TargetedConfigContext ctx, Caller caller, InstallDBContext idbCtx) throws PersistenceManagerException, RPCException, ConfigGenException {
        Host h = ctx.resolveHost(this.getHost());
        InstalledComponentID icid = h.getInstalledComponentID();
        if (icid == null) {
            throw PlanDBException.hostNotCreatedByComp(h.getName());
        }
        InstalledComponent ic = idbCtx.getInstalledComponent(icid);
        return new InstalledTarget(ic, this.getHost(ic, ctx), caller, (ComponentTargeterBase)this);
    }

    protected String getElementName() {
        return ELEMENT_NAME;
    }

    protected void populateXML(XML outXML) {
        XMLUtil.addAttributeIfNotNull(outXML, HOST_ATTR, this.getHost());
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof TargetableComponentTargeter)) {
            return false;
        }
        TargetableComponentTargeter targeter = (TargetableComponentTargeter)other;
        return ObjectUtil.equals(this.getHost(), targeter.getHost());
    }

    public Object generate(ConfigGenerator generator) throws ConfigGenException {
        TargetableComponentTargeter copy = (TargetableComponentTargeter)this.clone();
        copy.setHost(generator.generate(copy.getHost()));
        return copy;
    }

    void accept(PlanDBVisitor v) throws Exception {
        super.accept(v);
        v.visitToken(this.getHost());
    }

    ComponentTargeterBase accept(PlanDBTransformer t) throws Exception {
        TargetableComponentTargeter result = (TargetableComponentTargeter)super.accept(t);
        result.setHost(t.transformToken(this.getHost()));
        return result;
    }
}

