/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.plandb;

import com.raplix.rolloutexpress.config.ConfigGenException;
import com.raplix.rolloutexpress.config.ConfigGenerator;
import com.raplix.rolloutexpress.config.TargetedConfigContext;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.XMLUtil;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentType;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentTypeRef;
import com.raplix.rolloutexpress.systemmodel.componentdb.SingleComponentTypeRefQuery;
import com.raplix.rolloutexpress.systemmodel.hostdbx.Host;
import com.raplix.rolloutexpress.systemmodel.installdb.InstallDBContext;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponent;
import com.raplix.rolloutexpress.systemmodel.plandb.Caller;
import com.raplix.rolloutexpress.systemmodel.plandb.ComponentTargeterBase;
import com.raplix.rolloutexpress.systemmodel.plandb.InstalledComponentTargeter;
import com.raplix.rolloutexpress.systemmodel.plandb.InstalledTarget;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBPluginNSValidator;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBTransformer;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBVisitor;
import com.raplix.util.ObjectUtil;
import org.apache.ecs.xml.XML;
import org.w3c.dom.Element;

public class SystemTypeTargeter
extends ComponentTargeterBase
implements InstalledComponentTargeter {
    public static final String ELEMENT_NAME = "systemType";
    private static final String NAME_ATTR = "name";
    private static final String INSTALL_PATH_ATTR = "installPath";
    private static final String HOST_ATTR = "host";
    private String mSystemTypeName;
    private String mInstallPath;
    private String mHost;

    public SystemTypeTargeter(String systemTypeName, String installPath, String host) {
        this.setSystemTypeName(systemTypeName);
        this.setInstallPath(installPath);
        this.setHost(host);
    }

    SystemTypeTargeter(Element element) {
        this.setSystemTypeName(XMLUtil.getAttribute(element, NAME_ATTR));
        this.setInstallPath(XMLUtil.getAttribute(element, INSTALL_PATH_ATTR));
        this.setHost(XMLUtil.getAttribute(element, HOST_ATTR));
    }

    private SystemTypeTargeter() {
    }

    public String toString() {
        return this.lookupDesc("pdb.targeter.SYSTEM_TYPE", this.getSystemTypeName());
    }

    public String getSystemTypeName() {
        return this.mSystemTypeName;
    }

    private void setSystemTypeName(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        this.mSystemTypeName = name;
    }

    public String getInstallPath() {
        return this.mInstallPath;
    }

    private void setInstallPath(String installPath) {
        this.mInstallPath = installPath;
    }

    public String getHost() {
        return this.mHost;
    }

    private void setHost(String host) {
        this.mHost = host;
    }

    public InstalledTarget getInstalledTarget(TargetedConfigContext ctx, Caller caller, InstallDBContext idbCtx) throws PersistenceManagerException, RPCException, ConfigGenException {
        Host h = ctx.resolveHost(this.getHost());
        String name = this.getSystemTypeName();
        Component declared = ComponentType.create(name).getComponent();
        InstalledComponent instComp = idbCtx.getInstalledComponent(h.getID(), name, this.getInstallPath());
        return new InstalledTarget(instComp, declared, h, caller, (ComponentTargeterBase)this);
    }

    protected String getElementName() {
        return ELEMENT_NAME;
    }

    protected void populateXML(XML outXML) {
        XMLUtil.addAttributeIfNotNull(outXML, NAME_ATTR, this.getSystemTypeName());
        XMLUtil.addAttributeIfNotNull(outXML, INSTALL_PATH_ATTR, this.getInstallPath());
        XMLUtil.addAttributeIfNotNull(outXML, HOST_ATTR, this.getHost());
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof SystemTypeTargeter)) {
            return false;
        }
        SystemTypeTargeter targeter = (SystemTypeTargeter)other;
        return ObjectUtil.equals(this.getSystemTypeName(), targeter.getSystemTypeName()) && ObjectUtil.equals(this.getInstallPath(), targeter.getInstallPath()) && ObjectUtil.equals(this.getHost(), targeter.getHost());
    }

    public Object generate(ConfigGenerator generator) throws ConfigGenException {
        SystemTypeTargeter copy = (SystemTypeTargeter)this.clone();
        copy.setHost(generator.generate(copy.getHost()));
        copy.setInstallPath(generator.generate(copy.getInstallPath()));
        return copy;
    }

    void accept(PlanDBVisitor v) throws Exception {
        super.accept(v);
        v.visitToken(this.getHost());
        v.visitToken(this.getInstallPath());
    }

    ComponentTargeterBase accept(PlanDBTransformer t) throws Exception {
        SystemTypeTargeter result = (SystemTypeTargeter)super.accept(t);
        result.setHost(t.transformToken(this.getHost()));
        result.setInstallPath(t.transformToken(this.getInstallPath()));
        return result;
    }

    void validateNamespace(PlanDBPluginNSValidator v) throws Exception {
        super.validateNamespace(v);
        ComponentTypeRef ctr = SingleComponentTypeRefQuery.byName(this.getSystemTypeName()).selectReadOnlyView();
        v.getPlugin().validateNamespace(ctr.getPluginID(), this.getSystemTypeName(), this.getElementName());
    }
}

