/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.plandb;

import com.raplix.rolloutexpress.config.ConfigGenException;
import com.raplix.rolloutexpress.config.TargetedConfigContext;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.XMLUtil;
import com.raplix.rolloutexpress.systemmodel.componentdb.SingleSystemServiceRefQuery;
import com.raplix.rolloutexpress.systemmodel.componentdb.SystemServiceRef;
import com.raplix.rolloutexpress.systemmodel.installdb.InstallDBContext;
import com.raplix.rolloutexpress.systemmodel.plandb.Caller;
import com.raplix.rolloutexpress.systemmodel.plandb.ComponentTargeterBase;
import com.raplix.rolloutexpress.systemmodel.plandb.InstalledComponentTargeter;
import com.raplix.rolloutexpress.systemmodel.plandb.InstalledTarget;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBPluginNSValidator;
import com.raplix.util.ObjectUtil;
import org.apache.ecs.xml.XML;
import org.w3c.dom.Element;

public class SystemServiceTargeter
extends ComponentTargeterBase
implements InstalledComponentTargeter {
    public static final String ELEMENT_NAME = "systemService";
    private static final String NAME_ATTR = "name";
    private String mServiceName;

    public SystemServiceTargeter(String systemServiceName) {
        this.setSystemServiceName(systemServiceName);
    }

    SystemServiceTargeter(Element element) {
        this.setSystemServiceName(XMLUtil.getAttribute(element, NAME_ATTR));
    }

    private SystemServiceTargeter() {
    }

    public String toString() {
        return this.lookupDesc("pdb.targeter.SYSTEM_SERVICE", this.getSystemServiceName());
    }

    public String getSystemServiceName() {
        return this.mServiceName;
    }

    private void setSystemServiceName(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        this.mServiceName = name;
    }

    public InstalledTarget getInstalledTarget(TargetedConfigContext ctx, Caller caller, InstallDBContext installDBContext) throws PersistenceManagerException, RPCException, ConfigGenException {
        String name = this.getSystemServiceName();
        SystemServiceRef ssr = SingleSystemServiceRefQuery.byName(name).select();
        return this.getInstalledTarget(ssr.getInstalledComponentRef(), "/", ctx, caller, installDBContext);
    }

    protected String getElementName() {
        return ELEMENT_NAME;
    }

    protected void populateXML(XML outXML) {
        XMLUtil.addAttributeIfNotNull(outXML, NAME_ATTR, this.getSystemServiceName());
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof SystemServiceTargeter)) {
            return false;
        }
        SystemServiceTargeter targeter = (SystemServiceTargeter)other;
        return ObjectUtil.equals(this.getSystemServiceName(), targeter.getSystemServiceName());
    }

    void validateNamespace(PlanDBPluginNSValidator v) throws Exception {
        super.validateNamespace(v);
        SystemServiceRef ssr = SingleSystemServiceRefQuery.byName(this.getSystemServiceName()).select();
        v.getPlugin().validateNamespace(ssr.getPluginID(), this.getSystemServiceName(), this.getElementName());
    }
}

