/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.plandb;

import com.raplix.rolloutexpress.config.TargetedConfigContext;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.componentdb.CallSpec;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.installdb.InstallDBContext;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponent;
import com.raplix.rolloutexpress.systemmodel.plandb.Caller;
import com.raplix.rolloutexpress.systemmodel.plandb.ComponentTargeterBase;
import com.raplix.rolloutexpress.systemmodel.plandb.InstalledComponentTargeter;
import com.raplix.rolloutexpress.systemmodel.plandb.InstalledTarget;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBException;
import com.raplix.rolloutexpress.systemmodel.plandb.RepoComponentTargeter;
import com.raplix.rolloutexpress.systemmodel.plandb.RepoTarget;
import org.w3c.dom.Element;

public class SuperTargeter
extends ComponentTargeterBase
implements InstalledComponentTargeter,
RepoComponentTargeter {
    public static final String ELEMENT_NAME = "superComponent";

    public SuperTargeter() {
    }

    SuperTargeter(Element element) {
    }

    public String toString() {
        return this.lookupDesc("pdb.targeter.SUPER");
    }

    public boolean isInternalTarget() {
        return true;
    }

    public RepoTarget getRepoTarget(TargetedConfigContext ctx, Caller caller, InstallDBContext idbCtx) throws PersistenceManagerException, RPCException {
        return this.getInstalledTarget(ctx, caller, idbCtx);
    }

    public InstalledTarget getInstalledTarget(TargetedConfigContext ctx, Caller caller, InstallDBContext idbCtx) throws PersistenceManagerException, RPCException {
        InstalledComponent instComp = caller.getInstalledComponent();
        Component declaredComp = caller.getDeclaredComponent();
        if (!declaredComp.isDerivedComponent()) {
            instComp = null;
        }
        return new InstalledTarget(instComp, declaredComp, ctx.getTargetHost(), caller, (ComponentTargeterBase)this);
    }

    public void validate(Caller container) throws PlanDBException {
        Component comp = container.getDeclaredComponent();
        if (comp == null || !comp.isDerivedComponent()) {
            throw PlanDBException.superInNonDerivedComp();
        }
    }

    protected String getElementName() {
        return ELEMENT_NAME;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        return other instanceof SuperTargeter;
    }

    CallSpec getCallSpec(Caller caller, Component declaredComp) {
        return declaredComp.getSuperCallSpec();
    }
}

