/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.plandb;

import com.raplix.rolloutexpress.executor.query.SingleAutoGeneratedPlanQuery;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.persist.HasObjectID;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.StandardObject;
import com.raplix.rolloutexpress.persist.UsingObject;
import com.raplix.rolloutexpress.persist.VersionNumber;
import com.raplix.rolloutexpress.persist.VersionedData;
import com.raplix.rolloutexpress.persist.Visibility;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.NoResultsFoundException;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.folderdb.SummaryFolder;
import com.raplix.rolloutexpress.systemmodel.plandb.Caller;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanID;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanImpl;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanImplTable;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginID;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginMember;
import com.raplix.rolloutexpress.systemmodel.userdb.UserID;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;

public class SummaryExecutionPlan
implements StandardObject,
VersionedData,
RPCSerializable,
HasObjectID,
UsingObject,
PluginMember {
    private ExecutionPlanImpl mPlan;

    private SummaryExecutionPlan() {
    }

    SummaryExecutionPlan(ExecutionPlanImpl plan) {
        this.setPlan(plan);
    }

    ExecutionPlanImpl getPlan() {
        return this.mPlan;
    }

    void setPlan(ExecutionPlanImpl plan) {
        this.mPlan = plan;
    }

    public ObjectID getObjectID() {
        return this.getID();
    }

    public ExecutionPlanID getID() {
        return this.getPlan().getID();
    }

    public Visibility getVisibility() {
        return this.getPlan().getVisibility();
    }

    public int getUpdateCount() {
        return this.getPlan().getUpdateCount();
    }

    public String getName() {
        return this.getPlan().getName();
    }

    public FolderID getPath() {
        return this.getPlan().getPathID();
    }

    public String getFullName() {
        return this.getPlan().getFullName();
    }

    public String getDescription() {
        return this.getPlan().getDescription();
    }

    public Caller toCaller() {
        return new Caller(this);
    }

    public UserID getUserID() {
        return this.getPlan().getUserID();
    }

    public Date getTimeStamp() {
        return this.getPlan().getTimeStamp();
    }

    public VersionNumber getVersionNumber() {
        return this.getPlan().getVersionNumber();
    }

    public ObjectID getRootObjectID() {
        return this.getRootID();
    }

    public ExecutionPlanID getRootID() {
        return this.getPlan().getRootID();
    }

    public boolean isAutogenPlan() throws PersistenceManagerException {
        try {
            SingleAutoGeneratedPlanQuery.byExecutionPlanID(this.getID()).select();
            return true;
        }
        catch (NoResultsFoundException e) {
            return false;
        }
        catch (RPCException rpce) {
            throw new PersistenceManagerException(rpce);
        }
    }

    public static SummaryExecutionPlan createFromResultSet(ExecutionPlanImplTable table, ResultSet rs) throws PersistenceManagerException, SQLException {
        return table.retrieveObject(rs).getSummaryView();
    }

    public PluginID getPluginID() {
        return this.getPlan().getPluginID();
    }

    boolean isMoveNeeded(String name, SummaryFolder path) {
        return this.getPlan().isMoveNeeded(name, path);
    }
}

