/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.plandb;

import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.systemmodel.ObjectVisitorImpl;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecStep;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBException;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBVisitor;
import com.raplix.rolloutexpress.systemmodel.plandb.RaiseStep;
import com.raplix.rolloutexpress.systemmodel.plandb.ReturnStep;
import com.raplix.rolloutexpress.systemmodel.plandb.ValidationState;
import com.raplix.util.logger.Logger;

public class StepValidator
extends PlanDBVisitor {
    private boolean mIsReturnValue = false;
    private ValidationState rt = new ValidationState();

    public StepValidator(ObjectVisitorImpl ovi) {
        super(ovi);
    }

    public void visit(ExecStep[] s) throws Exception {
        this.rt.getCurrenState().startStepSeries();
        for (int i = 0; i < s.length; ++i) {
            this.visit(s[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visit(ExecStep s) throws Exception {
        if (this.rt.getCurrenState().isFoundReturnStep()) {
            throw PlanDBException.unreachableStepAfterReturn();
        }
        if (this.rt.getCurrenState().isFoundRaiseStep() && Logger.isWarnEnabled(this)) {
            Logger.warn(new ROXMessage("pdb.UNREACHABLE_STEP_AFTER_RAISE").toString(), this);
        }
        if (s instanceof ReturnStep) {
            if (this.mIsReturnValue && ((ReturnStep)s).getValue() == null) {
                throw PlanDBException.stepShouldReturnValue();
            }
            if (!this.mIsReturnValue && ((ReturnStep)s).getValue() != null) {
                throw PlanDBException.stepShouldNotReturnValue();
            }
        }
        this.rt.pushCallStack(s);
        try {
            super.visit(s);
            Object var3_2 = null;
            ValidationState.StepValidationState state = this.rt.popCallStack();
            state.mergeIntoParent(this.rt.getCurrenState());
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            ValidationState.StepValidationState state = this.rt.popCallStack();
            state.mergeIntoParent(this.rt.getCurrenState());
            throw throwable;
        }
        if (s instanceof ReturnStep) {
            this.rt.getCurrenState().setFoundReturnStep();
        }
        if (s instanceof RaiseStep) {
            this.rt.getCurrenState().setFoundRaiseStep();
        }
    }

    public void setIsReturnValue(boolean inFlag) {
        this.mIsReturnValue = inFlag;
    }

    public ValidationState getValidationState() {
        return this.rt;
    }
}

