/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.plandb;

import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.cache.CacheKey;
import com.raplix.rolloutexpress.persist.cache.SingleVersionedObjectByFullNameCache;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.SingleObjectErrorMapper;
import com.raplix.rolloutexpress.persist.query.SingleObjectQueryImpl;
import com.raplix.rolloutexpress.persist.query.builder.ConditionalExpression;
import com.raplix.rolloutexpress.persist.query.builder.Table;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.plandb.CompleteExecutionPlanProcessor;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlan;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanID;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanSQLOps;
import com.raplix.rolloutexpress.systemmodel.plandb.SummaryExecutionPlan;
import com.raplix.rolloutexpress.systemmodel.plandb.SummaryExecutionPlanProcessor;

public class SingleExecutionPlanQuery
extends SingleObjectQueryImpl {
    private static final ExecutionPlanSQLOps TABLE = new ExecutionPlanSQLOps("planT");

    public static SingleExecutionPlanQuery byName(FolderID inPathID, String name, String version) {
        if (inPathID == null) {
            inPathID = FolderID.ROOT_FOLDER_ID;
        }
        String cacheName = null;
        CacheKey cacheKey = null;
        if (version != null) {
            cacheName = "byFullNameAndVersion";
            cacheKey = SingleVersionedObjectByFullNameCache.createKey(inPathID, name, version);
        }
        ConditionalExpression cond = TABLE.isFullNameAndVersion(inPathID, name, version);
        SingleObjectErrorMapper mapper = SingleExecutionPlanQuery.getByNameErrorMapper(inPathID, name, version);
        return new SingleExecutionPlanQuery(cond, cacheName, cacheKey, mapper);
    }

    private SingleExecutionPlanQuery(ConditionalExpression whereCondition, String cacheName, CacheKey cacheKey, SingleObjectErrorMapper errorMapper) {
        super(TABLE, whereCondition, cacheName, cacheKey, errorMapper);
    }

    SingleExecutionPlanQuery(ExecutionPlanID ID2) {
        super((Table)TABLE, ID2);
    }

    public ExecutionPlan select() throws RPCException, PersistenceManagerException {
        CompleteExecutionPlanProcessor processor = new CompleteExecutionPlanProcessor(this.getTable(), true);
        return (ExecutionPlan)this.select(processor);
    }

    public SummaryExecutionPlan selectSummaryView() throws RPCException, PersistenceManagerException {
        SummaryExecutionPlanProcessor processor = new SummaryExecutionPlanProcessor(this.getTable(), true);
        return (SummaryExecutionPlan)this.select(processor);
    }
}

