/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.plandb;

import com.raplix.rolloutexpress.config.ConfigGenException;
import com.raplix.rolloutexpress.config.ConfigGenerator;
import com.raplix.rolloutexpress.systemmodel.plandb.ComponentStep;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecStep;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBTransformer;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBVisitor;
import com.raplix.rolloutexpress.systemmodel.plandb.SimplePlanStep;
import org.apache.ecs.xml.XML;
import org.w3c.dom.Element;

public class SendCustomEventStep
extends ExecStep
implements SimplePlanStep,
ComponentStep {
    public static final String ELEMENT_NAME = "sendCustomEvent";
    protected String mMessage;

    private SendCustomEventStep() {
    }

    public SendCustomEventStep(Element sendCustomEventElement) {
        super(sendCustomEventElement);
        this.setMessage(sendCustomEventElement.getAttribute("message"));
    }

    public SendCustomEventStep(String inMessage) {
        this.setMessage(inMessage);
    }

    public String getMessage() {
        return this.mMessage;
    }

    public void setMessage(String inValue) {
        this.mMessage = inValue;
    }

    protected void populateXML(XML outXML) {
        SendCustomEventStep.addAttributeIfNotNull(outXML, "message", this.getMessage());
    }

    public String getElementName() {
        return ELEMENT_NAME;
    }

    public boolean equals(ExecStep inStep) {
        if (!(inStep instanceof SendCustomEventStep)) {
            return false;
        }
        SendCustomEventStep theStep = (SendCustomEventStep)inStep;
        return theStep.getMessage().equals(this.mMessage);
    }

    public int getStepType() {
        return 108;
    }

    public ExecStep generate(ConfigGenerator generator) throws ConfigGenException {
        SendCustomEventStep copy = (SendCustomEventStep)super.generate(generator);
        copy.setMessage(generator.generate(copy.getMessage()));
        return copy;
    }

    void accept(PlanDBVisitor v) throws Exception {
        super.accept(v);
        v.visitToken(this.getMessage());
    }

    ExecStep accept(PlanDBTransformer t) throws Exception {
        SendCustomEventStep result = (SendCustomEventStep)super.accept(t);
        result.setMessage(t.transformToken(this.getMessage()));
        return result;
    }
}

