/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.plandb;

import com.raplix.rolloutexpress.config.ConfigGenException;
import com.raplix.rolloutexpress.config.ConfigGenerator;
import com.raplix.rolloutexpress.systemmodel.plandb.ComponentStep;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecStep;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBTransformer;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBVisitor;
import com.raplix.rolloutexpress.systemmodel.plandb.SimplePlanStep;
import org.apache.ecs.xml.XML;
import org.w3c.dom.Element;

public class ReturnStep
extends ExecStep
implements SimplePlanStep,
ComponentStep {
    private String mValue;
    public static final String ELEMENT_NAME = "return";
    private static final String VALUE_ATTR = "value";

    public ReturnStep(Element inElement) {
        super(inElement);
        this.setValue(ReturnStep.getAttribute(inElement, VALUE_ATTR));
    }

    public ReturnStep() {
    }

    public ReturnStep(String inValue) {
        this.setValue(inValue);
    }

    protected void populateXML(XML outXML) {
        ReturnStep.addAttributeIfNotNull(outXML, VALUE_ATTR, this.getValue());
    }

    public String getElementName() {
        return ELEMENT_NAME;
    }

    public boolean equals(ExecStep inStep) {
        if (!(inStep instanceof ReturnStep)) {
            return false;
        }
        ReturnStep rStep = (ReturnStep)inStep;
        if (this.getValue() == null) {
            return rStep.getValue() == null;
        }
        return this.getValue().equals(rStep.getValue());
    }

    void accept(PlanDBVisitor v) throws Exception {
        super.accept(v);
        v.visitToken(this.getValue());
    }

    ExecStep accept(PlanDBTransformer t) throws Exception {
        ReturnStep result = (ReturnStep)super.accept(t);
        result.setValue(t.transformToken(this.getValue()));
        return result;
    }

    public int getStepType() {
        return 138;
    }

    public String getValue() {
        return this.mValue;
    }

    public void setValue(String inValue) {
        this.mValue = inValue;
    }

    public ExecStep generate(ConfigGenerator generator) throws ConfigGenException {
        ReturnStep copy = (ReturnStep)super.generate(generator);
        copy.setValue(generator.generate(this.getValue()));
        return copy;
    }
}

