/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.plandb;

import com.raplix.rolloutexpress.config.ConfigGenException;
import com.raplix.rolloutexpress.config.ConfigGenerator;
import com.raplix.rolloutexpress.config.TokenCallContext;
import com.raplix.rolloutexpress.config.VariableSettingsSource;
import com.raplix.rolloutexpress.systemmodel.SystemModelParseException;
import com.raplix.rolloutexpress.systemmodel.plandb.AggregateStep;
import com.raplix.rolloutexpress.systemmodel.plandb.ComponentStep;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecStep;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBTransformer;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBVisitor;
import com.raplix.rolloutexpress.systemmodel.plandb.SimplePlanStep;
import com.raplix.rolloutexpress.systemmodel.plandb.VarList;
import java.util.Arrays;
import java.util.Vector;
import org.apache.ecs.xml.XML;
import org.w3c.dom.Element;

public class RetargetStep
extends ExecStep
implements SimplePlanStep,
ComponentStep,
AggregateStep {
    public static final String ELEMENT_NAME = "retarget";
    private static final String HOST_ATTR = "host";
    private String mHost;
    private VarList mLocalVars;
    private ExecStep[] mSteps;

    private RetargetStep() {
    }

    public RetargetStep(Element retargetElem) throws SystemModelParseException {
        super(retargetElem);
        this.setHost(RetargetStep.getAttribute(retargetElem, HOST_ATTR));
        this.setLocalVars(new VarList(retargetElem, null));
        Vector steps = new Vector();
        RetargetStep.parseExecSteps(retargetElem, steps);
        this.setSteps(steps);
    }

    public RetargetStep(String host, VariableSettingsSource localVars, ExecStep[] steps) {
        this.setHost(host);
        this.setLocalVars(localVars);
        this.setSteps(steps);
    }

    public String getHost() {
        return this.mHost;
    }

    private void setHost(String host) {
        if (host == null) {
            throw new NullPointerException();
        }
        this.mHost = host;
    }

    public VariableSettingsSource getLocalVars() {
        return (VariableSettingsSource)this.mLocalVars.clone();
    }

    private void setLocalVars(VariableSettingsSource localVars) {
        if (localVars == null) {
            this.setLocalVars(new VarList());
        } else {
            this.setLocalVars(new VarList(localVars));
        }
    }

    private void setLocalVars(VarList localVars) {
        this.mLocalVars = localVars;
    }

    public ExecStep[] getSteps() {
        return this.mSteps;
    }

    private void setSteps(ExecStep[] steps) {
        this.mSteps = RetargetStep.deepClone(steps);
    }

    private void setSteps(Vector steps) {
        this.mSteps = steps.toArray(new ExecStep[steps.size()]);
    }

    protected void populateXML(XML outXML) {
        RetargetStep.addAttributeIfNotNull(outXML, HOST_ATTR, this.getHost());
        this.mLocalVars.writeToXML(outXML);
        RetargetStep.writeSteps(outXML, this.mSteps);
    }

    public String getElementName() {
        return ELEMENT_NAME;
    }

    public boolean equals(ExecStep inStep) {
        if (!(inStep instanceof RetargetStep)) {
            return false;
        }
        RetargetStep theStep = (RetargetStep)inStep;
        return this.getHost().equals(theStep.getHost()) && this.equals(this.mLocalVars, theStep.mLocalVars) && Arrays.equals(this.mSteps, theStep.mSteps);
    }

    public int getStepType() {
        return 128;
    }

    public ExecStep generate(ConfigGenerator generator) throws ConfigGenException {
        RetargetStep copy = (RetargetStep)super.generate(generator);
        copy.setHost(generator.generate(copy.getHost()));
        return copy;
    }

    protected Object clone() {
        RetargetStep result = (RetargetStep)super.clone();
        result.setSteps(result.getSteps());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void accept(PlanDBVisitor v) throws Exception {
        super.accept(v);
        v.visitToken(this.getHost());
        TokenCallContext tcc = v.getTokenCallContext();
        tcc.pushVarScope(this);
        try {
            tcc.enterStepVarContext();
            try {
                v.visit(this.mLocalVars);
            }
            finally {
                tcc.exitContext();
            }
            v.visit(this.mSteps);
        }
        finally {
            tcc.popVarScope();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ExecStep accept(PlanDBTransformer t) throws Exception {
        RetargetStep result = (RetargetStep)super.accept(t);
        result.setHost(t.transformToken(this.getHost()));
        TokenCallContext tcc = t.getTokenCallContext();
        tcc.pushVarScope(this);
        try {
            tcc.enterStepVarContext();
            try {
                result.setLocalVars((VarList)t.transform(this.mLocalVars));
            }
            finally {
                tcc.exitContext();
            }
            for (int i = 0; i < this.mSteps.length; ++i) {
                result.mSteps[i] = t.transform(this.mSteps[i]);
            }
        }
        finally {
            tcc.popVarScope();
        }
        return result;
    }
}

