/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.plandb;

import com.raplix.rolloutexpress.systemmodel.componentdb.CallSpec;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentID;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentMember;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentRefDecl;
import com.raplix.rolloutexpress.systemmodel.componentdb.Modifier;
import com.raplix.rolloutexpress.systemmodel.hostdbx.Host;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponent;
import com.raplix.rolloutexpress.systemmodel.plandb.Caller;
import com.raplix.rolloutexpress.systemmodel.plandb.ComponentTargeterBase;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBException;

public class RepoTarget {
    private Component mActualComponent;
    private Component mDeclaredComponent;
    private ComponentTargeterBase mTargeter;
    private ComponentRefDecl mTargetingCompRef;
    private Host mHost;
    private Caller mCaller;

    RepoTarget(Component actual, Host host, Caller caller, ComponentTargeterBase targeter) throws PlanDBException {
        this(actual, actual, host, caller, targeter);
    }

    RepoTarget(Component actual, Component declared, Host host, Caller caller, ComponentTargeterBase targeter) throws PlanDBException {
        this(actual, declared, host, caller, null, targeter);
    }

    RepoTarget(Component actual, Component declared, Host host, Caller caller, ComponentRefDecl targetingRef, ComponentTargeterBase targeter) throws PlanDBException {
        if (Modifier.ABSTRACT.equals(actual.getModifier())) {
            throw PlanDBException.targetedCompAbstract(targeter);
        }
        this.setActualComponent(actual);
        if (declared == null) {
            declared = actual;
        }
        this.setDeclaredComponent(declared);
        this.setHost(host);
        this.setCaller(caller);
        this.setTargetingCompRef(targetingRef);
        this.setTargeter(targeter);
        if (!actual.isAccessible(this.getCallSpec())) {
            throw PlanDBException.targetedCompNotAccessible(targeter);
        }
    }

    public Component getActualComponent() {
        return this.mActualComponent;
    }

    private void setActualComponent(Component comp) {
        this.mActualComponent = comp;
    }

    private Component getDeclaredComponent() {
        return this.mDeclaredComponent;
    }

    private void setDeclaredComponent(Component comp) {
        this.mDeclaredComponent = comp;
    }

    private ComponentTargeterBase getTargeter() {
        return this.mTargeter;
    }

    private void setTargeter(ComponentTargeterBase targeter) {
        this.mTargeter = targeter;
    }

    public ComponentRefDecl getTargetingCompRef() {
        return this.mTargetingCompRef;
    }

    private void setTargetingCompRef(ComponentRefDecl targetingCompRef) {
        this.mTargetingCompRef = targetingCompRef;
    }

    public Host getHost() {
        return this.mHost;
    }

    private void setHost(Host host) {
        this.mHost = host;
    }

    public CallSpec getCallSpec() {
        return this.getTargeter().getCallSpec(this.getCaller(), this.getDeclaredComponent());
    }

    private Caller getCaller() {
        return this.mCaller;
    }

    private void setCaller(Caller caller) {
        this.mCaller = caller;
    }

    public Caller getCallerForMember(ComponentMember member, InstalledComponent callee) {
        if (!callee.getComponentID().equals(this.getActualComponent().getID())) {
            throw new IllegalArgumentException("not matching");
        }
        Component declaredComp = null;
        if (member != null) {
            declaredComp = member.getDeclaringComponent();
        } else {
            ComponentID declaredCompID = this.getCallSpec().getCalleeType();
            declaredComp = this.getDeclaredComponent().getAncestorByID(declaredCompID);
        }
        return new Caller(callee, this.getActualComponent(), declaredComp);
    }
}

