/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.plandb;

import com.raplix.rolloutexpress.systemmodel.plandb.ComponentStep;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecStep;
import com.raplix.rolloutexpress.systemmodel.plandb.SimplePlanStep;
import org.apache.ecs.xml.XML;
import org.w3c.dom.Element;

public class RebootStep
extends ExecStep
implements SimplePlanStep,
ComponentStep {
    public static final String ELEMENT_NAME = "reboot";
    private static final String TIMEOUT_ATTR = "timeout";
    public static final long TIMEOUT_UNSPECIFIED = Long.MIN_VALUE;
    private long mTimeout;

    public RebootStep(Element rebootElem) {
        super(rebootElem);
        this.setTimeout(RebootStep.getAttribute(rebootElem, TIMEOUT_ATTR));
    }

    public RebootStep(long timeout) {
        this.setTimeout(timeout);
    }

    private RebootStep() {
    }

    public long getTimeout() {
        return this.mTimeout;
    }

    private void setTimeout(long timeout) {
        this.mTimeout = timeout;
    }

    private void setTimeout(String val) {
        if (val == null) {
            this.setTimeout(Long.MIN_VALUE);
        } else {
            this.setTimeout(Long.parseLong(val));
        }
    }

    protected void populateXML(XML outXML) {
        if (this.getTimeout() != Long.MIN_VALUE) {
            RebootStep.addAttributeIfNotNull(outXML, TIMEOUT_ATTR, String.valueOf(this.getTimeout()));
        }
    }

    public String getElementName() {
        return ELEMENT_NAME;
    }

    public boolean equals(ExecStep inStep) {
        if (!(inStep instanceof RebootStep)) {
            return false;
        }
        RebootStep theStep = (RebootStep)inStep;
        return this.getTimeout() == theStep.getTimeout();
    }

    public int getStepType() {
        return 126;
    }
}

