/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.plandb;

import com.raplix.rolloutexpress.config.ConfigGenException;
import com.raplix.rolloutexpress.config.ConfigGenerator;
import com.raplix.rolloutexpress.systemmodel.plandb.ComponentStep;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecStep;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBTransformer;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBVisitor;
import com.raplix.rolloutexpress.systemmodel.plandb.SimplePlanStep;
import org.apache.ecs.xml.XML;
import org.w3c.dom.Element;

public class RaiseStep
extends ExecStep
implements SimplePlanStep,
ComponentStep {
    public static final String ELEMENT_NAME = "raise";
    private static final String MESSAGE_ATTR = "message";
    private String mMessage;

    private RaiseStep() {
    }

    public RaiseStep(Element raiseElem) {
        super(raiseElem);
        this.setMessage(RaiseStep.getAttribute(raiseElem, MESSAGE_ATTR));
    }

    public RaiseStep(String message) {
        this.setMessage(message);
    }

    public String getMessage() {
        return this.mMessage;
    }

    private void setMessage(String message) {
        this.mMessage = message;
    }

    protected void populateXML(XML outXML) {
        RaiseStep.addAttributeIfNotNull(outXML, MESSAGE_ATTR, this.getMessage());
    }

    public String getElementName() {
        return ELEMENT_NAME;
    }

    public boolean equals(ExecStep inStep) {
        if (!(inStep instanceof RaiseStep)) {
            return false;
        }
        RaiseStep theStep = (RaiseStep)inStep;
        return this.equals(theStep.getMessage(), this.getMessage());
    }

    public int getStepType() {
        return 124;
    }

    public ExecStep generate(ConfigGenerator generator) throws ConfigGenException {
        RaiseStep copy = (RaiseStep)super.generate(generator);
        copy.setMessage(generator.generate(copy.getMessage()));
        return copy;
    }

    void accept(PlanDBVisitor v) throws Exception {
        super.accept(v);
        v.visitToken(this.getMessage());
    }

    ExecStep accept(PlanDBTransformer t) throws Exception {
        RaiseStep result = (RaiseStep)super.accept(t);
        result.setMessage(t.transformToken(this.getMessage()));
        return result;
    }
}

