/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.plandb;

import com.raplix.rolloutexpress.config.TokenCallContext;
import com.raplix.rolloutexpress.config.VariableSettingsSource;
import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.systemmodel.XMLUtil;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBTransformer;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBVisitor;
import com.raplix.rolloutexpress.systemmodel.plandb.PromptParam;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.ecs.xml.XML;
import org.w3c.dom.Element;

public class PromptParamList
extends XMLUtil
implements VariableSettingsSource,
RPCSerializable,
Cloneable {
    private Hashtable mParamTable = new Hashtable();
    private Vector mParamNames = new Vector();
    public static final String ELEMENT_NAME = "paramList";

    public PromptParamList() {
    }

    public PromptParamList(VariableSettingsSource params) {
        String[] names = params.getVarNames();
        for (int i = 0; i < names.length; ++i) {
            String val = params.getVarValue(names[i]);
            this.addParam(new PromptParam(names[i], val, null, null));
        }
    }

    public PromptParamList(Element topElement) {
        Element[] paramListElem = PromptParamList.getChildren(topElement, ELEMENT_NAME);
        if (paramListElem.length > 0) {
            Element[] params = PromptParamList.getChildren(paramListElem[0], "param");
            for (int i = 0; i < params.length; ++i) {
                this.addParam(new PromptParam(params[i]));
            }
        }
    }

    public void writeToXML(XML topElem) {
        if (this.size() > 0) {
            XML paramList = new XML(ELEMENT_NAME);
            paramList.setPrettyPrint(true);
            String[] names = this.getVarNames();
            for (int i = 0; i < names.length; ++i) {
                PromptParam param = this.getParam(names[i]);
                param.writeToXML(paramList);
            }
            topElem.addElement((org.apache.ecs.Element)paramList);
        }
    }

    public String getVarValue(String paramName) {
        PromptParam param = this.getParam(paramName);
        if (param == null) {
            return null;
        }
        return param.getDefaultValue();
    }

    public PromptParam getParam(String paramName) {
        return (PromptParam)this.mParamTable.get(paramName);
    }

    public String[] getVarNames() {
        return this.mParamNames.toArray(new String[this.mParamNames.size()]);
    }

    public boolean containsVarValue(String paramName) {
        return this.getVarValue(paramName) != null;
    }

    public boolean containsParam(String paramName) {
        return this.mParamTable.containsKey(paramName);
    }

    public void addParam(PromptParam param) {
        if (this.mParamTable.put(param.getName(), param) == null) {
            this.mParamNames.addElement(param.getName());
        }
    }

    private int size() {
        return this.mParamNames.size();
    }

    public int hashCode() {
        return this.mParamTable.hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || !(other instanceof PromptParamList)) {
            return false;
        }
        PromptParamList otherList = (PromptParamList)other;
        return this.mParamTable.equals(otherList.mParamTable) && this.mParamNames.equals(otherList.mParamNames);
    }

    public Object clone() {
        try {
            PromptParamList result = (PromptParamList)super.clone();
            result.mParamTable = (Hashtable)result.mParamTable.clone();
            result.mParamNames = (Vector)result.mParamNames.clone();
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("{");
        String[] varNames = this.getVarNames();
        for (int i = 0; i < varNames.length; ++i) {
            buf.append("<").append(varNames[i]).append(",").append(this.getVarValue(varNames[i])).append(">,");
        }
        buf.append("}");
        return buf.toString();
    }

    void accept(PlanDBVisitor v) throws Exception {
        String[] varNames = this.getVarNames();
        for (int i = 0; i < varNames.length; ++i) {
            v.visitToken(this.getVarValue(varNames[i]));
        }
        TokenCallContext tcc = v.getTokenCallContext();
        for (int i = 0; i < varNames.length; ++i) {
            tcc.addVarDecl(varNames[i]);
        }
    }

    PromptParamList accept(PlanDBTransformer t) throws Exception {
        PromptParamList result = t.clone(this);
        String[] varNames = result.getVarNames();
        for (int i = 0; i < varNames.length; ++i) {
            PromptParam pram = result.getParam(varNames[i]);
            String value = t.transformToken(pram.getDefaultValue());
            PromptParam newPram = new PromptParam(pram.getName(), value, pram.getPrompt(), pram.getDisplayMode());
            result.addParam(newPram);
        }
        TokenCallContext tcc = t.getTokenCallContext();
        for (int i = 0; i < varNames.length; ++i) {
            tcc.addVarDecl(varNames[i]);
        }
        return result;
    }

    PromptParamList cloneForTransform() {
        return (PromptParamList)this.clone();
    }
}

