/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.plandb;

import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.systemmodel.XMLUtil;
import com.raplix.rolloutexpress.systemmodel.plandb.DisplayMode;
import com.raplix.util.ObjectUtil;
import org.apache.ecs.xml.XML;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class PromptParam
extends XMLUtil
implements RPCSerializable {
    private String mName;
    private String mDefaultValue;
    private String mPrompt;
    private DisplayMode mDisplayMode;
    public static final String ELEMENT_NAME = "param";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_DEFAULT = "default";
    private static final String ATTR_PROMPT = "prompt";
    private static final String ATTR_DISPLAY = "displayMode";
    private static final DisplayMode DEFAULT_DISPLAY = DisplayMode.CLEAR;

    private PromptParam() {
    }

    public PromptParam(String name) {
        this(name, null, null, null);
    }

    public PromptParam(String name, String defaultValue, String prompt, DisplayMode displayMode) {
        this.setName(name);
        this.setDefaultValue(defaultValue);
        this.setPrompt(prompt);
        this.setDisplayMode(displayMode);
    }

    public PromptParam(Element paramElem) {
        this.setName(PromptParam.getAttribute(paramElem, ATTR_NAME));
        Attr defaultAttr = paramElem.getAttributeNode(ATTR_DEFAULT);
        if (defaultAttr != null) {
            this.setDefaultValue(defaultAttr.getValue());
        }
        this.setPrompt(PromptParam.getAttribute(paramElem, ATTR_PROMPT));
        this.setDisplayMode((DisplayMode)PromptParam.getEnumAttribute(paramElem, ATTR_DISPLAY, DisplayMode.FACTORY));
    }

    public void writeToXML(XML topElem) {
        XML param = new XML(ELEMENT_NAME);
        param.setPrettyPrint(true);
        PromptParam.addAttributeIfNotNull(param, ATTR_NAME, this.getName());
        PromptParam.addAttributeIfNotNull(param, ATTR_PROMPT, this.getPrompt());
        PromptParam.addAttributeIfNotNull(param, ATTR_DEFAULT, this.getDefaultValue());
        if (!DEFAULT_DISPLAY.equals(this.getDisplayMode())) {
            PromptParam.addAttributeIfNotNull(param, ATTR_DISPLAY, this.getDisplayMode().toString());
        }
        topElem.addElement((org.apache.ecs.Element)param);
    }

    public String getName() {
        return this.mName;
    }

    private void setName(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        this.mName = name;
    }

    public String getDefaultValue() {
        return this.mDefaultValue;
    }

    private void setDefaultValue(String defaultValue) {
        this.mDefaultValue = defaultValue;
    }

    public boolean isRequired() {
        return this.getDefaultValue() == null;
    }

    public String getPrompt() {
        return this.mPrompt;
    }

    private void setPrompt(String prompt) {
        this.mPrompt = prompt;
    }

    public DisplayMode getDisplayMode() {
        return this.mDisplayMode;
    }

    private void setDisplayMode(DisplayMode displayMode) {
        if (displayMode == null) {
            displayMode = DEFAULT_DISPLAY;
        }
        this.mDisplayMode = displayMode;
    }

    public String getResolvedPrompt() {
        String result = this.getPrompt();
        if (result == null) {
            result = this.getName();
        }
        return result;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || !(other instanceof PromptParam)) {
            return false;
        }
        PromptParam otherParam = (PromptParam)other;
        return this.getName().equals(otherParam.getName()) && ObjectUtil.equals(this.getPrompt(), otherParam.getPrompt()) && ObjectUtil.equals(this.getDefaultValue(), otherParam.getDefaultValue()) && this.getDisplayMode().equals(otherParam.getDisplayMode());
    }
}

