/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.plandb;

import com.raplix.rolloutexpress.config.ConfigGenException;
import com.raplix.rolloutexpress.config.ConfigGenerator;
import com.raplix.rolloutexpress.systemmodel.plandb.ComponentStep;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecStep;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBTransformer;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBVisitor;
import com.raplix.rolloutexpress.systemmodel.plandb.SimplePlanStep;
import org.apache.ecs.xml.XML;
import org.w3c.dom.Element;

public class ProcessTestStep
extends ExecStep
implements SimplePlanStep,
ComponentStep {
    public static final String ELEMENT_NAME = "processTest";
    public static final int DEFAULT_DELAY = 1;
    public static final int DEFAULT_TIMEOUT = 5;
    protected String mProcessNamePattern;
    protected String mUser;
    protected int mDelaySecs;
    protected int mTimeoutSecs;

    private ProcessTestStep() {
    }

    public ProcessTestStep(Element processElement) {
        super(processElement);
        this.mProcessNamePattern = processElement.getAttribute("processNamePattern");
        this.mUser = processElement.getAttribute("user");
        this.setDelaySecs(processElement.getAttribute("delaySecs"));
        this.setTimeoutSecs(processElement.getAttribute("timeoutSecs"));
    }

    public ProcessTestStep(String inProcessNamePattern, String inUser, String inDelay, String inTimeout) {
        this.mProcessNamePattern = inProcessNamePattern;
        this.mUser = inUser;
        this.setDelaySecs(inDelay);
        this.setTimeoutSecs(inTimeout);
    }

    public String getProcessNamePattern() {
        return this.mProcessNamePattern;
    }

    public void setProcessNamePattern(String inValue) {
        this.mProcessNamePattern = inValue;
    }

    public String getUser() {
        return this.mUser;
    }

    public void setUser(String inValue) {
        this.mUser = inValue;
    }

    public int getDelaySecs() {
        return this.mDelaySecs;
    }

    public void setDelaySecs(int inValue) {
        this.mDelaySecs = inValue;
    }

    public void setDelaySecs(String inValue) throws NumberFormatException {
        this.mDelaySecs = inValue == null || inValue.equals("") ? 1 : Integer.parseInt(inValue);
    }

    public int getTimeoutSecs() {
        return this.mTimeoutSecs;
    }

    public void setTimeoutSecs(int inValue) {
        this.mTimeoutSecs = inValue;
    }

    public void setTimeoutSecs(String inValue) throws NumberFormatException {
        this.mTimeoutSecs = inValue == null || inValue.equals("") ? 5 : Integer.parseInt(inValue);
    }

    protected void populateXML(XML outXML) {
        ProcessTestStep.addAttributeIfNotNull(outXML, "processNamePattern", this.mProcessNamePattern);
        if (this.mUser != null && !this.mUser.equals("")) {
            ProcessTestStep.addAttributeIfNotNull(outXML, "user", this.mUser);
        }
        outXML.addAttribute("delaySecs", "" + this.mDelaySecs);
        outXML.addAttribute("timeoutSecs", "" + this.mTimeoutSecs);
    }

    public String getElementName() {
        return ELEMENT_NAME;
    }

    public boolean equals(ExecStep inStep) {
        if (!(inStep instanceof ProcessTestStep)) {
            return false;
        }
        ProcessTestStep theStep = (ProcessTestStep)inStep;
        if (!theStep.getProcessNamePattern().equals(this.mProcessNamePattern)) {
            return false;
        }
        if (!theStep.getUser().equals(this.mUser)) {
            return false;
        }
        if (theStep.getDelaySecs() != this.mDelaySecs) {
            return false;
        }
        return theStep.getTimeoutSecs() == this.mTimeoutSecs;
    }

    public int getStepType() {
        return 106;
    }

    public ExecStep generate(ConfigGenerator generator) throws ConfigGenException {
        ProcessTestStep copy = (ProcessTestStep)super.generate(generator);
        copy.setProcessNamePattern(generator.generate(copy.getProcessNamePattern()));
        copy.setUser(generator.generate(copy.getUser()));
        return copy;
    }

    void accept(PlanDBVisitor v) throws Exception {
        super.accept(v);
        v.visitToken(this.getProcessNamePattern());
        v.visitToken(this.getUser());
    }

    ExecStep accept(PlanDBTransformer t) throws Exception {
        ProcessTestStep result = (ProcessTestStep)super.accept(t);
        result.setProcessNamePattern(t.transformToken(this.getProcessNamePattern()));
        result.setUser(t.transformToken(this.getUser()));
        return result;
    }
}

