/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.plandb;

import com.raplix.rolloutexpress.config.TokenPluginNSValidator;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.ObjectVisitorImpl;
import com.raplix.rolloutexpress.systemmodel.componentdb.CompDBPluginNSValidator;
import com.raplix.rolloutexpress.systemmodel.plandb.Caller;
import com.raplix.rolloutexpress.systemmodel.plandb.ComponentTargeterBase;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecStep;
import com.raplix.rolloutexpress.systemmodel.plandb.InstalledComponentTargeter;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBException;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBVisitor;
import com.raplix.rolloutexpress.systemmodel.plugindb.Plugin;

public class PlanDBPluginNSValidator
extends PlanDBVisitor {
    Plugin mPlugin;
    Caller mCaller;

    PlanDBPluginNSValidator(Plugin plugin, Caller caller) {
        super(new ObjectVisitorImpl());
        this.setPlugin(plugin);
        this.setCaller(caller);
        new CompDBPluginNSValidator(this.getVisitor(), plugin, caller);
        new TokenPluginNSValidator(this.getVisitor(), plugin);
    }

    public PlanDBPluginNSValidator(ObjectVisitorImpl ovi, Plugin plugin, Caller caller) {
        super(ovi);
        this.setPlugin(plugin);
        this.setCaller(caller);
    }

    public void visit(ExecStep s) throws Exception {
        s.validateNamespace(this);
    }

    public void visit(InstalledComponentTargeter t) throws Exception {
        ((ComponentTargeterBase)((Object)t)).validateNamespace(this);
    }

    void visitHostSet(String s) throws PersistenceManagerException, RPCException {
        ((CompDBPluginNSValidator)this.getCompDBVisitor()).visitHostSet(s);
    }

    public Plugin getPlugin() {
        return this.mPlugin;
    }

    private void setPlugin(Plugin plugin) {
        this.mPlugin = plugin;
    }

    public Caller getCaller() {
        return this.mCaller;
    }

    private void setCaller(Caller caller) {
        this.mCaller = caller;
    }

    PersistenceManagerException mapException(Exception e) {
        if (e instanceof PersistenceManagerException) {
            return (PersistenceManagerException)e;
        }
        if (e instanceof RPCException) {
            return PlanDBException.unexpectedRPCError((RPCException)e);
        }
        throw new RuntimeException(e);
    }
}

