/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.plandb;

import com.raplix.rolloutexpress.config.ConfigGenException;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.componentdb.InstallMode;
import com.raplix.rolloutexpress.systemmodel.componentdb.SummaryComponent;
import com.raplix.rolloutexpress.systemmodel.folderdb.SummaryFolder;
import com.raplix.rolloutexpress.systemmodel.plandb.ComponentTargeterBase;
import com.raplix.rolloutexpress.systemmodel.plandb.Messages;
import com.raplix.rolloutexpress.systemmodel.plandb.SummaryExecutionPlan;

public class PlanDBException
extends PersistenceManagerException
implements Messages {
    protected PlanDBException() {
    }

    public PlanDBException(ROXMessage message) {
        super(message);
    }

    public PlanDBException(ROXMessage message, Throwable t) {
        super(message, t);
    }

    public PlanDBException(Throwable t) {
        super(t);
    }

    static PlanDBException configValidationError(ConfigGenException e) {
        return new PlanDBException(e);
    }

    static PlanDBException nameMustMatchRoot(String rootName) {
        return PlanDBException.newValidationError("pdb.ROOT_NAME_ERR", rootName);
    }

    static PlanDBException unexpectedRPCError(RPCException e) {
        return new PlanDBException(e);
    }

    static PlanDBException invalidMatchesPattern(String pat) {
        return PlanDBException.newValidationError("pdb.INVALID_MATCHES_PATTERN", pat);
    }

    static PlanDBException invalidPlanName(String name) {
        return PlanDBException.newValidationError("pdb.INVALID_PLAN_NAME", name);
    }

    static PlanDBException invalidPlanPath(String path) {
        return PlanDBException.newValidationError("pdb.INVALID_PLAN_PATH", path);
    }

    static PlanDBException unresolvedInstalledComponent(ComponentTargeterBase targeter) {
        return PlanDBException.newSystemError("pdb.UNRES_INST_COMP", targeter.toString());
    }

    static PlanDBException targetedCompAbstract(ComponentTargeterBase targeter) {
        return PlanDBException.newSystemError("pdb.ABSTRACT_TARGET_COMP", targeter.toString());
    }

    static PlanDBException targetedCompNotAccessible(ComponentTargeterBase targeter) {
        return PlanDBException.newSystemError("pdb.INACCESSIBLE_TARGET_COMP", targeter.toString());
    }

    static PlanDBException invalidCompRefInstallMode(SummaryComponent comp, String refName, InstallMode installMode) {
        String code = InstallMode.NESTED.equals(installMode) ? "pdb.COMPREF_NOT_NESTED" : "pdb.COMPREF_NOT_TOPLEVEL";
        return PlanDBException.newSystemError(code, comp.getName(), refName);
    }

    static PlanDBException noSuchCompRef(SummaryComponent comp, String refName) {
        return PlanDBException.newSystemError("pdb.NO_SUCH_COMPREF", comp.getName(), refName);
    }

    static PlanDBException compRefAlreadyInstalled(SummaryComponent comp, String refName) {
        return PlanDBException.newSystemError("pdb.COMPREF_INSTALLED", comp.getName(), refName);
    }

    static PlanDBException deployRsrcInCompositeComp() {
        return PlanDBException.newValidationError("pdb.DEPLOY_RSRC_IN_COMPOSITE_COMP");
    }

    static PlanDBException undeployRsrcInCompositeComp() {
        return PlanDBException.newValidationError("pdb.UNDEPLOY_RSRC_IN_COMPOSITE_COMP");
    }

    static PlanDBException captureRsrcInCompositeComp() {
        return PlanDBException.newValidationError("pdb.CAPTURE_RSRC_IN_COMPOSITE_COMP");
    }

    static PlanDBException superInNonDerivedComp() {
        return PlanDBException.newValidationError("pdb.SUPER_IN_NON_DERIVED_COMP");
    }

    static PlanDBException allNestedRefsInSimpleComp() {
        return PlanDBException.newValidationError("pdb.ALL_NESTED_REFS_IN_SIMPLE_COMP");
    }

    static PlanDBException invalidCreateSnapshot(String blockName) {
        return PlanDBException.newValidationError("pdb.INVALID_CREATE_SNAPSHOT", blockName);
    }

    static PlanDBException hostNotCreatedByComp(String hostName) {
        return PlanDBException.newSystemError("pdb.HOST_NOT_CREATED_BY_COMP", hostName);
    }

    static PlanDBException nameCollision(String oldName, String newName, String folderName) {
        return PlanDBException.newValidationError("pdb.NAME_COLLISION", new String[]{oldName, newName, folderName});
    }

    static PlanDBException pluginMustMatchRoot() {
        return PlanDBException.newValidationError("pdb.ROOT_PLUGIN_ERR");
    }

    static PlanDBException pluginMustMatchFolder(SummaryExecutionPlan plan, SummaryFolder path) {
        return PlanDBException.newValidationError("pdb.PLUGIN_FOLDER_ERR", new String[]{plan.getName(), path.getFullPathString()});
    }

    static PlanDBException stepShouldNotReturnValue() {
        return PlanDBException.newValidationError("pdb.SHOULD_NOT_RETURN_VALUE");
    }

    static PlanDBException stepShouldReturnValue() {
        return PlanDBException.newValidationError("pdb.SHOULD_RETURN_VALUE");
    }

    static PlanDBException unreachableStepAfterReturn() {
        return PlanDBException.newValidationError("pdb.UNREACHABLE_STEP_AFTER_RETURN");
    }

    static PlanDBException unreachableStepAfterRaise() {
        return PlanDBException.newValidationError("pdb.UNREACHABLE_STEP_AFTER_RAISE");
    }

    static PlanDBException newValidationError(String code) {
        return PlanDBException.newValidationError(code, new String[0]);
    }

    static PlanDBException newValidationError(String code, String arg) {
        return PlanDBException.newValidationError(code, new String[]{arg});
    }

    static PlanDBException newValidationError(String code, String[] args) {
        ROXMessage msg = new ROXMessage(code, (Object[])args, 2000);
        return new PlanDBException(msg);
    }

    static PlanDBException newValidationError(String code, Throwable t) {
        return PlanDBException.newValidationError(code, new String[0], t);
    }

    static PlanDBException newValidationError(String code, String[] args, Throwable t) {
        ROXMessage msg = new ROXMessage(code, (Object[])args, 2000);
        return new PlanDBException(msg, t);
    }

    static PlanDBException newSystemError(String code, String arg) {
        return PlanDBException.newValidationError(code, new String[]{arg});
    }

    static PlanDBException newSystemError(String code, String arg1, String arg2) {
        return PlanDBException.newValidationError(code, new String[]{arg1, arg2});
    }

    static PlanDBException newSystemError(String code, String[] args) {
        return new PlanDBException(new ROXMessage(code, args));
    }
}

