/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.plandb;

import com.raplix.rolloutexpress.config.TokenCallContext;
import com.raplix.rolloutexpress.config.VariableSettingsSource;
import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.systemmodel.SystemModelParseException;
import com.raplix.rolloutexpress.systemmodel.XMLUtil;
import com.raplix.rolloutexpress.systemmodel.plandb.CompositePlanStep;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecStep;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionMode;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanData;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBTransformer;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBVisitor;
import com.raplix.rolloutexpress.systemmodel.plandb.PromptParamList;
import com.raplix.rolloutexpress.systemmodel.plandb.SimplePlanStep;
import com.raplix.rolloutexpress.systemmodel.plandb.VarList;
import com.raplix.util.ObjectUtil;
import java.util.Arrays;
import java.util.Vector;
import org.apache.ecs.xml.XML;
import org.w3c.dom.Element;

class PlanBody
extends XMLUtil
implements RPCSerializable,
Cloneable {
    private ExecStep[] mSteps = new ExecStep[0];
    private String mVersion = null;
    private ExecutionMode mExecutionMode = DEFAULT_EXEC_MODE;
    private String mLimitToHostSet;
    private PromptParamList mParamList = new PromptParamList();
    private VarList mLocalVars = new VarList();
    private static final String ELEM_COMPOSITE_STEPS = "compositeSteps";
    private static final String ELEM_SIMPLE_STEPS = "simpleSteps";
    private static final String ATTR_VERSION = "version";
    private static final String ATTR_EXEC_MODE = "executionMode";
    private static final String ATTR_LIMIT_HOST_SET = "limitToHostSet";
    private static final ExecutionMode DEFAULT_EXEC_MODE = ExecutionMode.PARALLEL;
    private static final String DEFAULT_VERSION = "5.2";
    private static final String VERSION_5_0 = "5.0";
    private static final String VERSION_5_1 = "5.1";

    public PlanBody() {
        this.setSchemaVersion(DEFAULT_VERSION);
    }

    public PlanBody(Element topElement) throws SystemModelParseException {
        this.readFromXML(topElement);
    }

    public PlanBody(ExecutionPlanData plan) {
        this.setExecutionMode(plan.getExecutionMode());
        this.setLimitToHostSet(plan.getLimitToHostSet());
        this.setLocalVars(plan.getLocalVars());
        this.setExecSteps(plan.getExecSteps());
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public String getSchemaVersion() {
        return this.mVersion;
    }

    public void setSchemaVersion(String version) {
        this.mVersion = version != null && (version.equals(VERSION_5_0) || version.equals(VERSION_5_1)) ? DEFAULT_VERSION : version;
    }

    public ExecutionMode getExecutionMode() {
        return this.mExecutionMode;
    }

    public void setExecutionMode(ExecutionMode executionMode) {
        this.mExecutionMode = executionMode;
    }

    private void setExecutionMode(String modeString) {
        ExecutionMode mode = DEFAULT_EXEC_MODE;
        if (modeString != null) {
            mode = ExecutionMode.FACTORY.get(modeString);
        }
        this.setExecutionMode(mode);
    }

    public String getLimitToHostSet() {
        return this.mLimitToHostSet;
    }

    public void setLimitToHostSet(String name) {
        this.mLimitToHostSet = name;
    }

    public PromptParamList getParams() {
        return (PromptParamList)this.mParamList.clone();
    }

    public void setParams(PromptParamList params) {
        this.mParamList = (PromptParamList)params.clone();
    }

    public VariableSettingsSource getLocalVars() {
        return (VariableSettingsSource)this.mLocalVars.clone();
    }

    public void setLocalVars(VariableSettingsSource localVars) {
        this.mLocalVars = new VarList(localVars);
    }

    private static boolean allStepsInstanceOf(ExecStep[] steps, Class type) {
        for (int i = 0; i < steps.length; ++i) {
            if (type.isInstance(steps[i])) continue;
            return false;
        }
        return true;
    }

    public boolean isCompositePlan() {
        return PlanBody.allStepsInstanceOf(this.mSteps, CompositePlanStep.class);
    }

    public boolean isSimplePlan() {
        return PlanBody.allStepsInstanceOf(this.mSteps, SimplePlanStep.class);
    }

    public ExecStep[] getExecSteps() {
        return ExecStep.deepClone(this.mSteps);
    }

    public void setExecSteps(ExecStep[] inSteps) {
        this.mSteps = ExecStep.deepClone(inSteps);
    }

    private void setExecSteps(Vector inSteps) {
        ExecStep[] steps = new ExecStep[inSteps.size()];
        this.setExecSteps(inSteps.toArray(steps));
    }

    private void readFromXML(Element topElement) throws SystemModelParseException {
        this.setSchemaVersion(PlanBody.getAttribute(topElement, ATTR_VERSION));
        this.mParamList = new PromptParamList(topElement);
        this.mLocalVars = new VarList(topElement, this.mParamList);
        Element[] simpleSteps = PlanBody.getChildren(topElement, ELEM_SIMPLE_STEPS);
        if (simpleSteps.length > 0) {
            this.parseSimpleSteps(simpleSteps[0]);
        } else {
            Element[] compositeSteps = PlanBody.getChildren(topElement, ELEM_COMPOSITE_STEPS);
            this.parseCompositeSteps(compositeSteps[0]);
        }
    }

    private void parseSimpleSteps(Element stepsElem) throws SystemModelParseException {
        this.setExecutionMode(PlanBody.getAttribute(stepsElem, ATTR_EXEC_MODE));
        this.setLimitToHostSet(PlanBody.getAttribute(stepsElem, ATTR_LIMIT_HOST_SET));
        this.parseSteps(stepsElem);
    }

    private void parseCompositeSteps(Element stepsElem) throws SystemModelParseException {
        this.setExecutionMode((ExecutionMode)null);
        this.setLimitToHostSet(null);
        this.parseSteps(stepsElem);
    }

    private void parseSteps(Element stepsElem) throws SystemModelParseException {
        Vector steps = new Vector();
        ExecStep.parseExecSteps(stepsElem, steps);
        this.setExecSteps(steps);
    }

    public void writeToXML(XML thisElement) {
        XML stepList;
        PlanBody.addAttributeIfNotNull(thisElement, ATTR_VERSION, this.getSchemaVersion());
        this.mParamList.writeToXML(thisElement);
        this.mLocalVars.writeToXML(thisElement);
        if (this.isSimplePlan() && this.mSteps.length > 0) {
            stepList = new XML(ELEM_SIMPLE_STEPS);
            stepList.setPrettyPrint(true);
            ExecutionMode mode = this.getExecutionMode();
            if (mode != null && !DEFAULT_EXEC_MODE.equals(mode)) {
                PlanBody.addAttributeIfNotNull(stepList, ATTR_EXEC_MODE, mode.toString());
            }
            PlanBody.addAttributeIfNotNull(stepList, ATTR_LIMIT_HOST_SET, this.getLimitToHostSet());
        } else {
            stepList = new XML(ELEM_COMPOSITE_STEPS);
            stepList.setPrettyPrint(true);
        }
        ExecStep[] steps = this.mSteps;
        for (int i = 0; i < steps.length; ++i) {
            steps[i].writeToXML(stepList);
        }
        thisElement.addElement((org.apache.ecs.Element)stepList);
    }

    public boolean equalsPlanData(ExecutionPlanData otherPlan) {
        return otherPlan != null && ObjectUtil.equals(this.getExecutionMode(), otherPlan.getExecutionMode()) && ObjectUtil.equals(this.getLimitToHostSet(), otherPlan.getLimitToHostSet()) && this.mLocalVars.equalsVarSource(otherPlan.getLocalVars()) && Arrays.equals(this.mSteps, otherPlan.getExecSteps());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void accept(PlanDBVisitor v) throws Exception {
        TokenCallContext tcc = v.getTokenCallContext();
        tcc.pushVarScope();
        try {
            tcc.enterPlanParamContext();
            try {
                v.visit(this.mParamList);
            }
            finally {
                tcc.exitContext();
            }
            if (this.isSimplePlan()) {
                tcc.enterSimplePlanVarContext();
            } else {
                tcc.enterCompositePlanVarContext();
            }
            try {
                v.visit(this.mLocalVars);
            }
            finally {
                tcc.exitContext();
            }
            v.visit(this.mSteps);
        }
        finally {
            tcc.popVarScope();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PlanBody accept(PlanDBTransformer t) throws Exception {
        PlanBody pb = t.clone(this);
        TokenCallContext tcc = t.getTokenCallContext();
        tcc.pushVarScope();
        try {
            tcc.enterPlanParamContext();
            try {
                pb.mParamList = t.transform(this.mParamList);
            }
            finally {
                tcc.exitContext();
            }
            if (this.isSimplePlan()) {
                tcc.enterSimplePlanVarContext();
            } else {
                tcc.enterCompositePlanVarContext();
            }
            try {
                pb.mLocalVars = (VarList)t.transform(this.mLocalVars);
            }
            finally {
                tcc.exitContext();
            }
            for (int i = 0; i < pb.mSteps.length; ++i) {
                pb.mSteps[i] = t.transform(this.mSteps[i]);
            }
        }
        finally {
            tcc.popVarScope();
        }
        return pb;
    }

    PlanBody cloneForTransform() {
        PlanBody pb = (PlanBody)this.clone();
        pb.mSteps = (ExecStep[])pb.mSteps.clone();
        return pb;
    }
}

