/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.plandb;

import com.raplix.rolloutexpress.config.ConfigGenException;
import com.raplix.rolloutexpress.config.ConfigGenerator;
import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.systemmodel.XMLUtil;
import com.raplix.util.ObjectUtil;
import org.apache.ecs.xml.XML;
import org.w3c.dom.Element;

public class PerlSub
extends XMLUtil
implements RPCSerializable {
    public static final String ELEMENT_NAME = "subst";
    private static final String ATTR_MATCH = "match";
    private static final String ATTR_REPLACE = "replace";
    private String mMatch;
    private String mReplace;

    private PerlSub() {
    }

    public PerlSub(String match, String replace) {
        this.setMatch(match);
        this.setReplace(replace);
    }

    public PerlSub(Element substElem) {
        this.setMatch(PerlSub.getAttribute(substElem, ATTR_MATCH));
        this.setReplace(PerlSub.getAttribute(substElem, ATTR_REPLACE));
    }

    public void writeToXML(XML topElem) {
        XML subst = new XML(ELEMENT_NAME);
        subst.setPrettyPrint(true);
        PerlSub.addAttributeIfNotNull(subst, ATTR_MATCH, this.getMatch());
        PerlSub.addAttributeIfNotNull(subst, ATTR_REPLACE, this.getReplace());
        topElem.addElement((org.apache.ecs.Element)subst);
    }

    public String getMatch() {
        return this.mMatch;
    }

    private void setMatch(String match) {
        this.mMatch = match;
    }

    public String getReplace() {
        return this.mReplace;
    }

    private void setReplace(String replace) {
        this.mReplace = replace;
    }

    public PerlSub generate(ConfigGenerator generator) throws ConfigGenException {
        String match = generator.generate(this.getMatch());
        String replace = generator.generate(this.getReplace());
        return new PerlSub(match, replace);
    }

    public int hashCode() {
        return this.getMatch().hashCode() + this.getReplace().hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || !(other instanceof PerlSub)) {
            return false;
        }
        PerlSub otherSub = (PerlSub)other;
        return ObjectUtil.equals(this.getMatch(), otherSub.getMatch()) && ObjectUtil.equals(this.getReplace(), otherSub.getReplace());
    }
}

