/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.plandb;

import com.raplix.rolloutexpress.systemmodel.plandb.ComponentStep;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecStep;
import com.raplix.rolloutexpress.systemmodel.plandb.SimplePlanStep;
import org.apache.ecs.xml.XML;
import org.w3c.dom.Element;

public class PauseStep
extends ExecStep
implements SimplePlanStep,
ComponentStep {
    public static final String ELEMENT_NAME = "pause";
    protected int mDelaySecs;

    private PauseStep() {
    }

    public PauseStep(Element inElement) {
        super(inElement);
        this.setDelaySecs(inElement.getAttribute("delaySecs"));
    }

    public PauseStep(int inDelaySecs) {
        this.setDelaySecs(inDelaySecs);
    }

    protected void populateXML(XML outXML) {
        outXML.addAttribute("delaySecs", "" + this.mDelaySecs);
    }

    public String getElementName() {
        return ELEMENT_NAME;
    }

    public int getDelaySecs() {
        return this.mDelaySecs;
    }

    public void setDelaySecs(int inValue) {
        this.mDelaySecs = inValue;
    }

    public void setDelaySecs(String inValue) throws NumberFormatException {
        this.mDelaySecs = Integer.parseInt(inValue);
    }

    public boolean equals(ExecStep inStep) {
        if (!(inStep instanceof PauseStep)) {
            return false;
        }
        PauseStep pauseStep = (PauseStep)inStep;
        return pauseStep.getDelaySecs() == this.getDelaySecs();
    }

    public int getStepType() {
        return 115;
    }
}

