/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.plandb;

import com.raplix.rolloutexpress.config.ConfigGenException;
import com.raplix.rolloutexpress.config.ConfigGenerator;
import com.raplix.rolloutexpress.systemmodel.XMLUtil;
import com.raplix.rolloutexpress.systemmodel.plandb.BooleanOperator;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBException;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBTransformer;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBVisitor;
import org.apache.ecs.xml.XML;
import org.w3c.dom.Element;

public class NotOperator
extends BooleanOperator {
    public static final String ELEMENT_NAME = "not";
    private BooleanOperator mCond;

    private NotOperator() {
    }

    public NotOperator(BooleanOperator op) {
        this.setCondition(op);
    }

    NotOperator(Element elem) {
        this.setCondition(NotOperator.readFromXML(XMLUtil.getFirstChild(elem)));
    }

    public boolean evaluate() throws PlanDBException {
        return !this.getCondition().evaluate();
    }

    public BooleanOperator getCondition() {
        return this.mCond;
    }

    private void setCondition(BooleanOperator cond) {
        if (cond == null) {
            throw new NullPointerException();
        }
        this.mCond = cond;
    }

    protected void populateXML(XML outXML) {
        this.getCondition().writeToXML(outXML);
    }

    public String getElementName() {
        return ELEMENT_NAME;
    }

    protected void toString(StringBuffer outBuf) {
        outBuf.append(this.getElementName()).append("(");
        outBuf.append(this.getCondition().toString());
        outBuf.append(")");
    }

    protected boolean equalsOperator(BooleanOperator op) {
        if (!(op instanceof NotOperator)) {
            return false;
        }
        NotOperator otherOp = (NotOperator)op;
        return this.getCondition().equals(otherOp.getCondition());
    }

    public BooleanOperator generate(ConfigGenerator generator) throws ConfigGenException {
        NotOperator copy = (NotOperator)super.generate(generator);
        copy.setCondition(copy.getCondition().generate(generator));
        return copy;
    }

    void accept(PlanDBVisitor v) throws Exception {
        super.accept(v);
        v.visit(this.getCondition());
    }

    BooleanOperator accept(PlanDBTransformer t) throws Exception {
        NotOperator no = (NotOperator)super.accept(t);
        no.setCondition(t.transform(this.getCondition()));
        return no;
    }
}

