/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.plandb;

import com.raplix.rolloutexpress.config.TargetedConfigContext;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.XMLUtil;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentRefDecl;
import com.raplix.rolloutexpress.systemmodel.componentdb.InstallMode;
import com.raplix.rolloutexpress.systemmodel.hostdbx.Host;
import com.raplix.rolloutexpress.systemmodel.installdb.InstallDBContext;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponent;
import com.raplix.rolloutexpress.systemmodel.plandb.Caller;
import com.raplix.rolloutexpress.systemmodel.plandb.ComponentTargeterBase;
import com.raplix.rolloutexpress.systemmodel.plandb.InstalledComponentTargeter;
import com.raplix.rolloutexpress.systemmodel.plandb.InstalledTarget;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBException;
import com.raplix.rolloutexpress.systemmodel.plandb.RepoComponentTargeter;
import com.raplix.rolloutexpress.systemmodel.plandb.RepoTarget;
import com.raplix.util.ObjectUtil;
import org.apache.ecs.xml.XML;
import org.w3c.dom.Element;

public class NestedRefTargeter
extends ComponentTargeterBase
implements RepoComponentTargeter,
InstalledComponentTargeter {
    public static final String ELEMENT_NAME = "nestedRef";
    private static final String NAME_ATTR = "name";
    private String mNestedRefName;

    public NestedRefTargeter(String nestedRefName) {
        this.setNestedRefName(nestedRefName);
    }

    NestedRefTargeter(Element element) {
        this.setNestedRefName(XMLUtil.getAttribute(element, NAME_ATTR));
    }

    private NestedRefTargeter() {
    }

    public String toString() {
        return this.lookupDesc("pdb.targeter.NESTED_REF", this.getNestedRefName());
    }

    public String getNestedRefName() {
        return this.mNestedRefName;
    }

    private void setNestedRefName(String name) {
        this.mNestedRefName = name;
    }

    private InstalledComponent resolveInstComp(TargetedConfigContext ctx, Caller caller, InstallDBContext installDBContext) throws PersistenceManagerException, RPCException {
        return installDBContext.getNestedComponent(caller.getInstalledComponent().getID(), this.getNestedRefName());
    }

    private ComponentRefDecl resolveRef(Caller caller) throws PlanDBException {
        return this.resolveRef(caller, this.getNestedRefName(), InstallMode.NESTED);
    }

    public RepoTarget getRepoTarget(TargetedConfigContext ctx, Caller caller, InstallDBContext installDBContext) throws PersistenceManagerException, RPCException {
        Host h = ctx.getTargetHost();
        ComponentRefDecl ref = this.resolveRef(caller);
        Component target = ref.getComponent().getID().getByIDQuery().select();
        if (this.resolveInstComp(ctx, caller, installDBContext) != null) {
            Component callerComp = caller.getActualComponent();
            throw PlanDBException.compRefAlreadyInstalled(callerComp, this.getNestedRefName());
        }
        return new RepoTarget(target, this.getDeclaredTypeOfRef(ref, caller), h, caller, ref, this);
    }

    public InstalledTarget getInstalledTarget(TargetedConfigContext ctx, Caller caller, InstallDBContext installDBContext) throws PersistenceManagerException, RPCException {
        ComponentRefDecl ref = this.resolveRef(caller);
        InstalledComponent instComp = this.resolveInstComp(ctx, caller, installDBContext);
        return new InstalledTarget(instComp, this.getDeclaredTypeOfRef(ref, caller), this.getHost(instComp, ctx), caller, (ComponentTargeterBase)this);
    }

    public void validate(Caller container) throws PlanDBException {
        this.resolveRef(container);
    }

    protected String getElementName() {
        return ELEMENT_NAME;
    }

    protected void populateXML(XML outXML) {
        XMLUtil.addAttributeIfNotNull(outXML, NAME_ATTR, this.getNestedRefName());
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof NestedRefTargeter)) {
            return false;
        }
        NestedRefTargeter targeter = (NestedRefTargeter)other;
        return ObjectUtil.equals(this.getNestedRefName(), targeter.getNestedRefName());
    }
}

