/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.plandb;

import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.AcquireWriteLockRPCTransaction;
import com.raplix.rolloutexpress.persist.HasObjectID;
import com.raplix.rolloutexpress.persist.PersistContext;
import com.raplix.rolloutexpress.persist.StandardObject;
import com.raplix.rolloutexpress.persist.Visibility;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.MultiSelectableObjectQuery;
import com.raplix.rolloutexpress.persist.query.MultiStandardObjectQueryImpl;
import com.raplix.rolloutexpress.persist.query.ObjectOrder;
import com.raplix.rolloutexpress.persist.query.QueryContext;
import com.raplix.rolloutexpress.persist.query.VersionRange;
import com.raplix.rolloutexpress.persist.query.builder.ConditionalExpression;
import com.raplix.rolloutexpress.persist.query.builder.Table;
import com.raplix.rolloutexpress.persist.query.builder.TableList;
import com.raplix.rolloutexpress.systemmodel.catdb.CategoryID;
import com.raplix.rolloutexpress.systemmodel.catdb.CategoryIDSet;
import com.raplix.rolloutexpress.systemmodel.catdb.CategoryUpdateContext;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.folderdb.FullPathFilter;
import com.raplix.rolloutexpress.systemmodel.folderdb.SummaryFolder;
import com.raplix.rolloutexpress.systemmodel.plandb.CompleteExecutionPlanProcessor;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlan;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanID;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanIDSet;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanOrder;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanSQLOps;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanToCategoryLinkTable;
import com.raplix.rolloutexpress.systemmodel.plandb.SummaryExecutionPlan;
import com.raplix.rolloutexpress.systemmodel.plandb.SummaryExecutionPlanProcessor;
import java.security.AccessControlException;
import java.util.HashSet;

public class MultiExecutionPlanQuery
extends MultiStandardObjectQueryImpl
implements MultiSelectableObjectQuery {
    private static final ExecutionPlanSQLOps TABLE = new ExecutionPlanSQLOps("planT");
    private VersionRange mVersionFilter;
    private CategoryID mCategoryFilter;
    private FullPathFilter mFullPathFilter;
    private boolean mExcludeSentinelPlan = true;

    public static MultiExecutionPlanQuery all() {
        MultiExecutionPlanQuery result = new MultiExecutionPlanQuery((ConditionalExpression)null);
        result.setObjectOrder(ExecutionPlanOrder.BY_ACTIVE_DESC);
        result.setVisibilityFilter(Visibility.VISIBLE);
        return result;
    }

    static MultiExecutionPlanQuery allVersionsOf(ExecutionPlanID planID) {
        MultiExecutionPlanQuery result = new MultiExecutionPlanQuery(TABLE.isVersionOf(planID));
        result.setObjectOrder(ExecutionPlanOrder.BY_VERSION_DESC);
        return result;
    }

    static MultiExecutionPlanQuery byIDs(ExecutionPlanIDSet idSet) {
        MultiExecutionPlanQuery result = new MultiExecutionPlanQuery(idSet);
        return result;
    }

    private MultiExecutionPlanQuery(ConditionalExpression condition) {
        super((Table)TABLE, condition, ExecutionPlanOrder.FACTORY);
    }

    private MultiExecutionPlanQuery(ExecutionPlanIDSet idSet) {
        super((Table)TABLE, idSet.toIDArray(), ExecutionPlanOrder.FACTORY);
        this.setExcludeSentinelPlan(idSet.contains(ExecutionPlanID.PLAN_SENTINEL_ID));
    }

    public void setObjectOrder(ObjectOrder order) {
        super.setObjectOrder((ExecutionPlanOrder)order);
    }

    public VersionRange getVersionFilter() {
        return this.mVersionFilter;
    }

    public void setVersionFilter(VersionRange versionFilter) {
        this.mVersionFilter = versionFilter;
    }

    public CategoryID getCategoryFilter() {
        return this.mCategoryFilter;
    }

    public void setCategoryFilter(CategoryID filter) {
        this.mCategoryFilter = filter;
    }

    public FullPathFilter getFullPathFilter() {
        return this.mFullPathFilter;
    }

    public void setFullPathFilter(FullPathFilter pathFilter) {
        this.mFullPathFilter = pathFilter;
    }

    private boolean getExcludeSentinelPlan() {
        return this.mExcludeSentinelPlan;
    }

    private void setExcludeSentinelPlan(boolean exclude) {
        this.mExcludeSentinelPlan = exclude;
    }

    public StandardObject[] selectStandardObjectView() throws RPCException, PersistenceManagerException {
        return this.selectSummaryView();
    }

    public ExecutionPlan[] select() throws RPCException, PersistenceManagerException {
        CompleteExecutionPlanProcessor processor = new CompleteExecutionPlanProcessor(this.getTable(), false);
        return (ExecutionPlan[])this.select(processor, ExecutionPlan.class);
    }

    public HasObjectID[] selectObjects() throws RPCException, PersistenceManagerException {
        return this.selectSummaryView();
    }

    public SummaryExecutionPlan[] selectSummaryView() throws RPCException, PersistenceManagerException {
        SummaryExecutionPlanProcessor processor = new SummaryExecutionPlanProcessor(this.getTable(), false);
        return (SummaryExecutionPlan[])this.select(processor, SummaryExecutionPlan.class);
    }

    protected void addFilterCondition(QueryContext ctx) throws RPCException, PersistenceManagerException {
        super.addFilterCondition(ctx);
        ExecutionPlanSQLOps t = (ExecutionPlanSQLOps)this.getTable();
        if (this.getVersionFilter() != null) {
            ctx.addAndWhereCondition(t.matchesVersion(this.getVersionFilter()));
        }
        if (this.getCategoryFilter() != null) {
            ctx.addAndWhereCondition(t.matchesCat(this.getCategoryFilter()));
        }
        if (this.getFullPathFilter() != null) {
            this.getFullPathFilter().addFilterCondition(ctx, t);
        }
        if (this.getExcludeSentinelPlan()) {
            ctx.addAndWhereCondition(ExecutionPlanSQLOps.not(ExecutionPlanSQLOps.equals(t.ID, ExecutionPlanID.PLAN_SENTINEL_ID)));
        }
    }

    protected TableList getTableList() {
        TableList theResult = super.getTableList();
        if (this.getFullPathFilter() != null) {
            theResult = this.getFullPathFilter().getTableList(theResult);
        }
        return theResult;
    }

    public CategoryIDSet selectSharedCategories() throws RPCException, PersistenceManagerException {
        return PlanToCategoryLinkTable.DEFAULT.getSharedCategories(this.selectIDs());
    }

    public int updateCategories(CategoryUpdateContext ctx) throws RPCException, PersistenceManagerException {
        return PlanToCategoryLinkTable.DEFAULT.updateCategories(this.selectIDs(), ctx);
    }

    public int updateVisibility(Visibility vis) throws RPCException, PersistenceManagerException {
        return super.updateVisibility(vis);
    }

    public void move(FolderID path) throws PersistenceManagerException, RPCException, AccessControlException {
        if (path == null) {
            return;
        }
        MultiExecutionPlanQuery.move(this.selectSummaryView(), path);
    }

    static void move(final SummaryExecutionPlan[] plans, final FolderID path) throws RPCException, PersistenceManagerException {
        if (path == null) {
            return;
        }
        MultiExecutionPlanQuery.transactRPC(new AcquireWriteLockRPCTransaction(){

            protected PersistContext executeMS() throws PersistenceManagerException {
                try {
                    SummaryFolder f = path == null ? null : path.getByIDQuery().selectSummaryView();
                    MultiExecutionPlanQuery.trMoveMS(plans, f);
                    return null;
                }
                catch (RPCException e) {
                    throw new PersistenceManagerException(e);
                }
            }

            public ROXMessage getLockDescription() {
                return new ROXMessage("pdb.MOVING_PLANS");
            }
        });
    }

    static void trMoveMS(SummaryExecutionPlan[] plans, SummaryFolder path) throws PersistenceManagerException {
        HashSet<ExecutionPlanID> roots = new HashSet<ExecutionPlanID>();
        for (int i = 0; i < plans.length; ++i) {
            if (!roots.add(plans[i].getRootID())) continue;
            ExecutionPlanID.trMoveMS(plans[i].getRootID(), null, path);
        }
    }

    public static void trMoveMS(SummaryFolder path) throws PersistenceManagerException, AccessControlException {
        if (path == null) {
            return;
        }
        MultiExecutionPlanQuery mq = MultiExecutionPlanQuery.all();
        mq.setVisibilityFilter(null);
        mq.setObjectOrder(null);
        mq.setFullPathFilter(new FullPathFilter(path.getID(), null, false));
        try {
            SummaryExecutionPlan[] plans = mq.selectSummaryView();
            MultiExecutionPlanQuery.trMoveMS(plans, path);
        }
        catch (RPCException e) {
            throw new PersistenceManagerException(e);
        }
    }
}

