/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.plandb;

import com.raplix.rolloutexpress.config.ConfigGenException;
import com.raplix.rolloutexpress.config.ConfigGenerator;
import com.raplix.rolloutexpress.systemmodel.XMLUtil;
import com.raplix.rolloutexpress.systemmodel.plandb.BooleanOperator;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBException;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBTransformer;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBVisitor;
import com.raplix.util.regex.RegEx;
import com.raplix.util.regex.RegExSyntaxException;
import org.apache.ecs.xml.XML;
import org.w3c.dom.Element;

public class MatchesOperator
extends BooleanOperator {
    public static final String ELEMENT_NAME = "matches";
    private static final String VALUE_ATTR = "value";
    private static final String PATTERN_ATTR = "pattern";
    private static final String EXACT_ATTR = "exact";
    private String mValue;
    private String mPattern;
    private static final boolean DEFAULT_EXACT = false;
    private boolean mExact;

    private MatchesOperator() {
    }

    public MatchesOperator(String value, String pattern, boolean exact) {
        this.setValue(value);
        this.setPattern(pattern);
        this.setExact(exact);
    }

    MatchesOperator(Element elem) {
        this.setValue(XMLUtil.getAttribute(elem, VALUE_ATTR));
        this.setPattern(XMLUtil.getAttribute(elem, PATTERN_ATTR));
        this.setExact(XMLUtil.getBooleanAttribute(elem, EXACT_ATTR));
    }

    public boolean evaluate() throws PlanDBException {
        String value = this.getValue();
        String pat = this.getPattern();
        if (!this.exact()) {
            value = value.toLowerCase();
            pat = pat.toLowerCase();
        }
        try {
            return RegEx.match(RegEx.createPreciseWildcard(pat), value);
        }
        catch (RegExSyntaxException e) {
            throw PlanDBException.invalidMatchesPattern(pat);
        }
    }

    public String getValue() {
        return this.mValue;
    }

    private void setValue(String val) {
        if (val == null) {
            throw new NullPointerException();
        }
        this.mValue = val;
    }

    public String getPattern() {
        return this.mPattern;
    }

    private void setPattern(String pat) {
        if (pat == null) {
            throw new NullPointerException();
        }
        this.mPattern = pat;
    }

    public boolean exact() {
        return this.mExact;
    }

    private void setExact(Boolean exact) {
        boolean resolvedExact = false;
        if (exact != null) {
            resolvedExact = exact;
        }
        this.setExact(resolvedExact);
    }

    private void setExact(boolean exact) {
        this.mExact = exact;
    }

    protected void populateXML(XML outXML) {
        XMLUtil.addAttributeIfNotNull(outXML, VALUE_ATTR, this.getValue());
        XMLUtil.addAttributeIfNotNull(outXML, PATTERN_ATTR, this.getPattern());
        if (this.exact()) {
            XMLUtil.addAttributeIfNotNull(outXML, EXACT_ATTR, String.valueOf(this.exact()));
        }
    }

    public String getElementName() {
        return ELEMENT_NAME;
    }

    protected void toString(StringBuffer outBuf) {
        this.wrapValue(outBuf, this.getValue());
        outBuf.append(" ").append(this.getElementName());
        if (this.exact()) {
            outBuf.append(" ").append("[").append(EXACT_ATTR).append("]");
        }
        outBuf.append(" ");
        this.wrapValue(outBuf, this.getPattern());
    }

    protected boolean equalsOperator(BooleanOperator op) {
        if (!(op instanceof MatchesOperator)) {
            return false;
        }
        MatchesOperator otherOp = (MatchesOperator)op;
        return this.getValue().equals(otherOp.getValue()) && this.getPattern().equals(otherOp.getPattern()) && this.exact() == otherOp.exact();
    }

    public BooleanOperator generate(ConfigGenerator generator) throws ConfigGenException {
        MatchesOperator copy = (MatchesOperator)super.generate(generator);
        copy.setValue(generator.generate(copy.getValue()));
        copy.setPattern(generator.generate(copy.getPattern()));
        return copy;
    }

    void accept(PlanDBVisitor v) throws Exception {
        super.accept(v);
        v.visitToken(this.getValue());
        v.visitToken(this.getPattern());
    }

    BooleanOperator accept(PlanDBTransformer t) throws Exception {
        MatchesOperator result = (MatchesOperator)super.accept(t);
        result.setValue(t.transformToken(this.getValue()));
        result.setPattern(t.transformToken(this.getPattern()));
        return result;
    }
}

