/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.plandb;

import com.raplix.rolloutexpress.config.ConfigGenException;
import com.raplix.rolloutexpress.config.ConfigGenerator;
import com.raplix.rolloutexpress.systemmodel.XMLUtil;
import com.raplix.rolloutexpress.systemmodel.plandb.BooleanOperator;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBTransformer;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBVisitor;
import java.util.Arrays;
import org.apache.ecs.xml.XML;
import org.w3c.dom.Element;

public abstract class ListOperator
extends BooleanOperator {
    private BooleanOperator[] mConds;

    protected ListOperator() {
    }

    public ListOperator(BooleanOperator[] ops) {
        this.setConditions(ops, true);
    }

    ListOperator(Element elem) {
        this.setConditions(this.readChildrenFromXML(elem), false);
    }

    private BooleanOperator[] readChildrenFromXML(Element xml) {
        Element[] elems = XMLUtil.getChildren(xml);
        BooleanOperator[] ops = new BooleanOperator[elems.length];
        for (int i = 0; i < ops.length; ++i) {
            ops[i] = ListOperator.readFromXML(elems[i]);
        }
        return ops;
    }

    public BooleanOperator[] getConditions() {
        return (BooleanOperator[])this.mConds.clone();
    }

    protected BooleanOperator[] getConditionsForRead() {
        return this.mConds;
    }

    private void setConditions(BooleanOperator[] conds, boolean copy) {
        if (conds == null) {
            throw new NullPointerException();
        }
        if (copy) {
            conds = (BooleanOperator[])conds.clone();
        }
        this.mConds = conds;
    }

    protected void populateXML(XML outXML) {
        BooleanOperator[] ops = this.getConditionsForRead();
        for (int i = 0; i < ops.length; ++i) {
            ops[i].writeToXML(outXML);
        }
    }

    protected boolean equalsListOperator(ListOperator otherOp) {
        return Arrays.equals(this.getConditionsForRead(), otherOp.getConditionsForRead());
    }

    protected void toString(StringBuffer outBuf) {
        outBuf.append(this.getElementName()).append("(");
        BooleanOperator[] ops = this.getConditionsForRead();
        for (int i = 0; i < ops.length; ++i) {
            if (i != 0) {
                outBuf.append(", ");
            }
            outBuf.append(ops[i].toString());
        }
        outBuf.append(")");
    }

    public BooleanOperator generate(ConfigGenerator generator) throws ConfigGenException {
        ListOperator copy = (ListOperator)super.generate(generator);
        BooleanOperator[] ops = copy.getConditions();
        for (int i = 0; i < ops.length; ++i) {
            ops[i] = ops[i].generate(generator);
        }
        copy.setConditions(ops, false);
        return copy;
    }

    void accept(PlanDBVisitor v) throws Exception {
        super.accept(v);
        BooleanOperator[] ops = this.getConditionsForRead();
        for (int i = 0; i < ops.length; ++i) {
            v.visit(ops[i]);
        }
    }

    BooleanOperator accept(PlanDBTransformer t) throws Exception {
        ListOperator result = (ListOperator)super.accept(t);
        BooleanOperator[] ops = result.getConditions();
        for (int i = 0; i < ops.length; ++i) {
            ops[i] = t.transform(ops[i]);
        }
        result.setConditions(ops, false);
        return result;
    }
}

