/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.plandb;

import com.raplix.rolloutexpress.config.ConfigGenException;
import com.raplix.rolloutexpress.config.ConfigGenerator;
import com.raplix.rolloutexpress.systemmodel.XMLUtil;
import com.raplix.rolloutexpress.systemmodel.plandb.BooleanOperator;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBTransformer;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBVisitor;
import org.apache.ecs.xml.XML;
import org.w3c.dom.Element;

public class IsTrueOperator
extends BooleanOperator {
    public static final String ELEMENT_NAME = "istrue";
    private static final String VALUE_ATTR = "value";
    private String mValue;

    private IsTrueOperator() {
    }

    public IsTrueOperator(String value) {
        this.setValue(value);
    }

    IsTrueOperator(Element elem) {
        this.setValue(XMLUtil.getAttribute(elem, VALUE_ATTR));
    }

    public boolean evaluate() {
        return Boolean.valueOf(this.getValue());
    }

    public String getValue() {
        return this.mValue;
    }

    private void setValue(String value) {
        if (value == null) {
            throw new NullPointerException();
        }
        this.mValue = value;
    }

    protected void populateXML(XML outXML) {
        XMLUtil.addAttributeIfNotNull(outXML, VALUE_ATTR, this.getValue());
    }

    public String getElementName() {
        return ELEMENT_NAME;
    }

    protected void toString(StringBuffer outBuf) {
        outBuf.append(this.getElementName()).append(" ");
        this.wrapValue(outBuf, this.getValue());
    }

    protected boolean equalsOperator(BooleanOperator op) {
        if (!(op instanceof IsTrueOperator)) {
            return false;
        }
        IsTrueOperator otherOp = (IsTrueOperator)op;
        return this.getValue().equals(otherOp.getValue());
    }

    public BooleanOperator generate(ConfigGenerator generator) throws ConfigGenException {
        IsTrueOperator copy = (IsTrueOperator)super.generate(generator);
        copy.setValue(generator.generate(copy.getValue()));
        return copy;
    }

    void accept(PlanDBVisitor v) throws Exception {
        super.accept(v);
        v.visitToken(this.getValue());
    }

    BooleanOperator accept(PlanDBTransformer t) throws Exception {
        IsTrueOperator result = (IsTrueOperator)super.accept(t);
        result.setValue(t.transformToken(this.getValue()));
        return result;
    }
}

