/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.plandb;

import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentMember;
import com.raplix.rolloutexpress.systemmodel.hostdbx.Host;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponent;
import com.raplix.rolloutexpress.systemmodel.plandb.Caller;
import com.raplix.rolloutexpress.systemmodel.plandb.ComponentTargeterBase;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBException;
import com.raplix.rolloutexpress.systemmodel.plandb.RepoTarget;

public class InstalledTarget
extends RepoTarget {
    private InstalledComponent mInstalledComponent;

    InstalledTarget(InstalledComponent instComp, Host h, Caller caller, ComponentTargeterBase targeter) throws PersistenceManagerException, RPCException {
        this(instComp, null, h, caller, targeter);
    }

    InstalledTarget(InstalledComponent instComp, Component declared, Host h, Caller caller, ComponentTargeterBase targeter) throws PersistenceManagerException, RPCException {
        super(InstalledTarget.resolveComponent(instComp, targeter), declared, h, caller, targeter);
        this.setInstalledComponent(instComp);
    }

    private static Component resolveComponent(InstalledComponent instComp, ComponentTargeterBase targeter) throws PersistenceManagerException, RPCException {
        if (instComp == null) {
            throw PlanDBException.unresolvedInstalledComponent(targeter);
        }
        return instComp.getComponentID().getByIDQuery().select();
    }

    public InstalledComponent getInstalledComponent() {
        return this.mInstalledComponent;
    }

    private void setInstalledComponent(InstalledComponent instComp) {
        this.mInstalledComponent = instComp;
    }

    public Caller getCallerForMember(ComponentMember member, InstalledComponent callee) {
        return this.getCallerForMember(member);
    }

    public Caller getCallerForMember(ComponentMember member) {
        return super.getCallerForMember(member, this.getInstalledComponent());
    }
}

