/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.plandb;

import com.raplix.rolloutexpress.config.ConfigGenException;
import com.raplix.rolloutexpress.config.ConfigGenerator;
import com.raplix.rolloutexpress.config.VariableSettingsSource;
import com.raplix.rolloutexpress.systemmodel.SystemModelParseException;
import com.raplix.rolloutexpress.systemmodel.componentdb.NamedBlockType;
import com.raplix.rolloutexpress.systemmodel.plandb.AggregateStep;
import com.raplix.rolloutexpress.systemmodel.plandb.ArgList;
import com.raplix.rolloutexpress.systemmodel.plandb.AssigningStep;
import com.raplix.rolloutexpress.systemmodel.plandb.BlockCallerStep;
import com.raplix.rolloutexpress.systemmodel.plandb.Caller;
import com.raplix.rolloutexpress.systemmodel.plandb.ComponentTargeterFactory;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecStep;
import com.raplix.rolloutexpress.systemmodel.plandb.InstallBlockStep;
import com.raplix.rolloutexpress.systemmodel.plandb.InstallChildNotMappable;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBException;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBTransformer;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBVisitor;
import com.raplix.rolloutexpress.systemmodel.plandb.RepoComponentTargeter;
import com.raplix.rolloutexpress.systemmodel.plandb.SimplePlanStep;
import com.raplix.rolloutexpress.systemmodel.plandb.ThisTargeter;
import com.raplix.util.ObjectUtil;
import org.apache.ecs.xml.XML;
import org.w3c.dom.Element;

public class InstallStep
extends ExecStep
implements SimplePlanStep,
InstallBlockStep,
BlockCallerStep,
AggregateStep,
InstallChildNotMappable,
AssigningStep {
    public static final String ELEMENT_NAME = "install";
    private static final String ATTR_BLOCK_NAME = "blockName";
    private static final String ELEMENT_ASSIGN = "assign";
    private static final String ATTR_VARNAME = "varName";
    private String mAssignTo;
    private RepoComponentTargeter mTargeter;
    private String mBlockName;
    private ArgList mArgs;
    private transient Object mClientData;

    private InstallStep() {
    }

    public InstallStep(Element installElement) throws SystemModelParseException {
        super(installElement);
        this.setTargeter(ComponentTargeterFactory.getRepoTargeter(installElement));
        this.setBlockName(InstallStep.getAttribute(installElement, ATTR_BLOCK_NAME));
        this.mArgs = new ArgList(installElement);
        Element[] elements = InstallStep.getChildren(installElement, ELEMENT_ASSIGN);
        if (elements.length > 0) {
            this.setAssignTo(InstallStep.getAttribute(elements[0], ATTR_VARNAME));
        }
    }

    public InstallStep(RepoComponentTargeter targeter, String inBlockName) {
        this(targeter, inBlockName, new ArgList());
    }

    public InstallStep(RepoComponentTargeter targeter, String inBlockName, VariableSettingsSource args) {
        this(targeter, inBlockName, args, null);
    }

    public InstallStep(RepoComponentTargeter targeter, String inBlockName, VariableSettingsSource args, String inAssignVarName) {
        this.setTargeter(targeter);
        this.mBlockName = inBlockName;
        this.setArgs(args);
        this.setAssignTo(inAssignVarName);
    }

    public RepoComponentTargeter getTargeter() {
        return this.mTargeter;
    }

    private void setTargeter(RepoComponentTargeter targeter) {
        if (targeter == null) {
            targeter = new ThisTargeter();
        }
        this.mTargeter = targeter;
    }

    public String getBlockName() {
        return this.mBlockName;
    }

    public void setBlockName(String blockName) {
        this.mBlockName = blockName;
    }

    public VariableSettingsSource getArgs() {
        return (VariableSettingsSource)this.mArgs.clone();
    }

    private void setArgs(VariableSettingsSource args) {
        this.mArgs = new ArgList(args);
    }

    public NamedBlockType getBlockType() {
        return NamedBlockType.INSTALL;
    }

    public ExecStep generate(ConfigGenerator generator) throws ConfigGenException {
        InstallStep result = (InstallStep)super.generate(generator);
        result.mArgs = this.mArgs.generate(generator);
        result.setTargeter((RepoComponentTargeter)result.getTargeter().generate(generator));
        return result;
    }

    protected void populateXML(XML outXML) {
        InstallStep.addAttributeIfNotNull(outXML, ATTR_BLOCK_NAME, this.getBlockName());
        this.mArgs.writeToXML(outXML);
        outXML.addElement((org.apache.ecs.Element)this.getTargeter().writeToXML());
        if (this.getAssignTo() != null) {
            XML assign = new XML(ELEMENT_ASSIGN);
            assign.setPrettyPrint(true);
            InstallStep.addAttributeIfNotNull(assign, ATTR_VARNAME, this.getAssignTo());
            outXML.addElement((org.apache.ecs.Element)assign);
        }
    }

    public void validate(Caller container) throws PlanDBException {
        this.getTargeter().validate(container);
    }

    public String getElementName() {
        return ELEMENT_NAME;
    }

    public boolean equals(ExecStep inStep) {
        if (!(inStep instanceof InstallStep)) {
            return false;
        }
        InstallStep theStep = (InstallStep)inStep;
        if (!ObjectUtil.equals(theStep.getTargeter(), this.getTargeter())) {
            return false;
        }
        if (!ObjectUtil.equals(this.getBlockName(), theStep.getBlockName())) {
            return false;
        }
        return this.mArgs.equals(theStep.mArgs);
    }

    public int getStepType() {
        return 105;
    }

    public Object getClientData() {
        return this.mClientData;
    }

    public void setClientData(Object clientData) {
        this.mClientData = clientData;
    }

    void accept(PlanDBVisitor v) throws Exception {
        super.accept(v);
        v.visit(this.getTargeter());
        v.visit(this.mArgs);
        v.visitMutableVar(this.getAssignTo());
    }

    ExecStep accept(PlanDBTransformer t) throws Exception {
        InstallStep result = (InstallStep)super.accept(t);
        result.setTargeter(t.transform(this.getTargeter()));
        result.mArgs = (ArgList)t.transform(this.mArgs);
        return result;
    }

    public String getAssignTo() {
        return this.mAssignTo;
    }

    public void setAssignTo(String inVarname) {
        this.mAssignTo = inVarname;
    }
}

