/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.plandb;

import com.raplix.rolloutexpress.config.VariableSettingsSource;
import com.raplix.rolloutexpress.systemmodel.SystemModelParseException;
import com.raplix.rolloutexpress.systemmodel.plandb.AggregateStep;
import com.raplix.rolloutexpress.systemmodel.plandb.CompositePlanStep;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecStep;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionMode;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanData;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanBody;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBTransformer;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBVisitor;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanNameRefAdder;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanNameRefUpdater;
import com.raplix.util.ObjectUtil;
import org.apache.ecs.xml.XML;
import org.w3c.dom.Element;

public class InlineSubplanStep
extends ExecStep
implements CompositePlanStep,
ExecutionPlanData,
AggregateStep {
    public static final String ELEMENT_NAME = "inlineSubplan";
    private static final String ATTR_NAME = "planName";
    private static final String ATTR_DESC = "description";
    private String mName;
    private String mDescription;
    private PlanBody mBody;

    private InlineSubplanStep() {
    }

    public InlineSubplanStep(Element stepElement) throws SystemModelParseException {
        super(stepElement);
        this.setName(InlineSubplanStep.getAttribute(stepElement, ATTR_NAME));
        this.setDescription(InlineSubplanStep.getAttribute(stepElement, ATTR_DESC));
        this.setBody(new PlanBody(stepElement));
    }

    public InlineSubplanStep(ExecutionPlanData plan) {
        this.setName(plan.getName());
        this.setDescription(plan.getDescription());
        this.setBody(new PlanBody(plan));
    }

    public String getName() {
        return this.mName;
    }

    private void setName(String name) {
        this.mName = name;
    }

    public String getDescription() {
        return this.mDescription;
    }

    private void setDescription(String description) {
        if (description != null && description.length() == 0) {
            description = null;
        }
        this.mDescription = description;
    }

    private PlanBody getBody() {
        return this.mBody;
    }

    private void setBody(PlanBody body) {
        this.mBody = body;
    }

    public ExecutionMode getExecutionMode() {
        return this.getBody().getExecutionMode();
    }

    public String getLimitToHostSet() {
        return this.getBody().getLimitToHostSet();
    }

    public VariableSettingsSource getLocalVars() {
        return this.getBody().getLocalVars();
    }

    public boolean isCompositePlan() {
        return this.getBody().isCompositePlan();
    }

    public boolean isSimplePlan() {
        return this.getBody().isSimplePlan();
    }

    public ExecStep[] getExecSteps() {
        return this.getBody().getExecSteps();
    }

    protected void populateXML(XML outXML) {
        InlineSubplanStep.addAttributeIfNotNull(outXML, ATTR_NAME, this.getName());
        InlineSubplanStep.addAttributeIfNotNull(outXML, ATTR_DESC, this.getDescription());
        this.getBody().writeToXML(outXML);
    }

    public String getElementName() {
        return ELEMENT_NAME;
    }

    public boolean equals(ExecStep inStep) {
        if (!(inStep instanceof InlineSubplanStep)) {
            return false;
        }
        InlineSubplanStep theStep = (InlineSubplanStep)inStep;
        return this.equalsPlanData(theStep);
    }

    public boolean equalsPlanData(ExecutionPlanData thePlan) {
        return ObjectUtil.equals(this.getName(), thePlan.getName()) && ObjectUtil.equals(this.getDescription(), thePlan.getDescription()) && this.getBody().equalsPlanData(thePlan);
    }

    public int getStepType() {
        return 117;
    }

    protected Object clone() {
        InlineSubplanStep result = (InlineSubplanStep)super.clone();
        result.mBody = (PlanBody)result.mBody.clone();
        return result;
    }

    void accept(PlanDBVisitor v) throws Exception {
        super.accept(v);
        v.visit(this.getBody());
    }

    ExecStep accept(PlanDBTransformer t) throws Exception {
        InlineSubplanStep result = (InlineSubplanStep)super.accept(t);
        result.setBody(t.transform(this.getBody()));
        return result;
    }

    void addPlanRefsMS(PlanNameRefAdder adder) throws Exception {
        this.accept(adder);
    }

    ExecStep updatePlanRefsMS(PlanNameRefUpdater updater) throws Exception {
        return this.accept(updater);
    }
}

