/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.plandb;

import com.raplix.rolloutexpress.config.ConfigGenException;
import com.raplix.rolloutexpress.config.ConfigGenerator;
import com.raplix.rolloutexpress.systemmodel.SystemModelParseException;
import com.raplix.rolloutexpress.systemmodel.plandb.BooleanOperator;
import com.raplix.rolloutexpress.systemmodel.plandb.ComponentStep;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecStep;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBTransformer;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBVisitor;
import com.raplix.rolloutexpress.systemmodel.plandb.SimplePlanStep;
import com.raplix.rolloutexpress.systemmodel.plandb.TargetVariableStep;
import java.util.Arrays;
import org.apache.ecs.xml.XML;
import org.w3c.dom.Element;

public class IfStep
extends ExecStep
implements SimplePlanStep,
ComponentStep,
TargetVariableStep {
    public static final String ELEMENT_NAME = "if";
    private static final String CONDITION_ELEM = "condition";
    private static final String THEN_ELEM = "then";
    private static final String ELSE_ELEM = "else";
    private BooleanOperator mCondition;
    private ExecStep[] mThenSteps;
    private ExecStep[] mElseSteps;

    private IfStep() {
    }

    public IfStep(Element ifElem) throws SystemModelParseException {
        super(ifElem);
        this.setCondition(this.parseCondition(ifElem));
        this.setThenSteps(IfStep.parseStepBlock(ifElem, THEN_ELEM), false);
        this.setElseSteps(IfStep.parseStepBlock(ifElem, ELSE_ELEM), false);
    }

    private BooleanOperator parseCondition(Element elem) {
        Element[] conds = IfStep.getChildren(elem, CONDITION_ELEM);
        if (conds.length == 0) {
            return null;
        }
        return BooleanOperator.readFromXML(IfStep.getFirstChild(conds[0]));
    }

    public IfStep(BooleanOperator condition, ExecStep[] thenSteps, ExecStep[] elseSteps) {
        this.setCondition(condition);
        this.setThenSteps(thenSteps, true);
        this.setElseSteps(elseSteps, true);
    }

    public BooleanOperator getCondition() {
        return this.mCondition;
    }

    private void setCondition(BooleanOperator condition) {
        if (condition == null) {
            throw new NullPointerException();
        }
        this.mCondition = condition;
    }

    public ExecStep[] getThenSteps() {
        return this.mThenSteps;
    }

    private void setThenSteps(ExecStep[] thenSteps, boolean copy) {
        if (thenSteps == null) {
            throw new NullPointerException();
        }
        if (copy) {
            thenSteps = IfStep.deepClone(thenSteps);
        }
        this.mThenSteps = thenSteps;
    }

    public ExecStep[] getElseSteps() {
        return this.mElseSteps;
    }

    private void setElseSteps(ExecStep[] elseSteps, boolean copy) {
        if (elseSteps != null && copy) {
            elseSteps = IfStep.deepClone(elseSteps);
        }
        this.mElseSteps = elseSteps;
    }

    protected void populateXML(XML outXML) {
        XML cond = new XML(CONDITION_ELEM);
        cond.setPrettyPrint(true);
        this.getCondition().writeToXML(cond);
        outXML.addElement((org.apache.ecs.Element)cond);
        IfStep.writeStepBlock(outXML, THEN_ELEM, this.mThenSteps);
        IfStep.writeStepBlock(outXML, ELSE_ELEM, this.mElseSteps);
    }

    public String getElementName() {
        return ELEMENT_NAME;
    }

    public boolean equals(ExecStep inStep) {
        if (!(inStep instanceof IfStep)) {
            return false;
        }
        IfStep theStep = (IfStep)inStep;
        return this.equals(this.getCondition(), theStep.getCondition()) && Arrays.equals(this.mThenSteps, theStep.mThenSteps) && Arrays.equals(this.mElseSteps, theStep.mElseSteps);
    }

    public int getStepType() {
        return 127;
    }

    public ExecStep generate(ConfigGenerator generator) throws ConfigGenException {
        IfStep result = (IfStep)super.generate(generator);
        result.setCondition(result.getCondition().generate(generator));
        return result;
    }

    protected Object clone() {
        IfStep result = (IfStep)super.clone();
        result.setThenSteps(result.getThenSteps(), true);
        result.setElseSteps(result.getElseSteps(), true);
        return result;
    }

    void accept(PlanDBVisitor v) throws Exception {
        super.accept(v);
        v.visit(this.getCondition());
        v.visit(this.mThenSteps);
        if (this.mElseSteps != null) {
            v.visit(this.mElseSteps);
        }
    }

    ExecStep accept(PlanDBTransformer t) throws Exception {
        IfStep result = (IfStep)super.accept(t);
        result.setCondition(t.transform(this.getCondition()));
        ExecStep[] thenSteps = this.getThenSteps();
        for (int i = 0; i < thenSteps.length; ++i) {
            result.mThenSteps[i] = t.transform(this.mThenSteps[i]);
        }
        ExecStep[] elseSteps = this.getElseSteps();
        if (elseSteps != null) {
            for (int j = 0; j < elseSteps.length; ++j) {
                result.mElseSteps[j] = t.transform(this.mElseSteps[j]);
            }
        }
        return result;
    }
}

