/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.plandb;

import com.raplix.rolloutexpress.executor.TaskInfo;
import com.raplix.rolloutexpress.persist.query.QueryContext;
import com.raplix.rolloutexpress.persist.query.VersionRange;
import com.raplix.rolloutexpress.persist.query.builder.ColumnNode;
import com.raplix.rolloutexpress.persist.query.builder.ConditionalExpression;
import com.raplix.rolloutexpress.persist.query.builder.OrderByList;
import com.raplix.rolloutexpress.persist.query.builder.Table;
import com.raplix.rolloutexpress.systemmodel.catdb.CategoryID;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderImplTable;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanImplTable;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanToCategoryLinkTable;

class ExecutionPlanSQLOps
extends ExecutionPlanImplTable {
    public static final ExecutionPlanSQLOps DEFAULT = new ExecutionPlanSQLOps();

    public ExecutionPlanSQLOps(String alias) {
        super(alias);
    }

    private ExecutionPlanSQLOps() {
        this(null);
    }

    public Table instance() {
        return DEFAULT;
    }

    public Table instance(String alias) {
        return new ExecutionPlanSQLOps(alias);
    }

    public ConditionalExpression matchesVersion(VersionRange range) {
        return range.getConditional(this.Version);
    }

    public ConditionalExpression matchesCat(CategoryID catID) {
        return PlanToCategoryLinkTable.DEFAULT.matchesCategoryID(catID, this.ID);
    }

    public ConditionalExpression isFullNameAndVersion(FolderID inPathID, String name, String version) {
        return ExecutionPlanSQLOps.and(ExecutionPlanSQLOps.and(ExecutionPlanSQLOps.equals(this.PathID, inPathID), ExecutionPlanSQLOps.equals(this.Name, name)), this.matchesVersion(version));
    }

    public OrderByList orderByActiveAsc(QueryContext ctx) {
        OrderByList result = ExecutionPlanSQLOps.oList(ExecutionPlanSQLOps.orderByAsc(ExecutionPlanSQLOps.exists(TaskInfo.getSelectForRunningPlans(this.ID))));
        result.add(this.orderByNameAsc(ctx));
        return result;
    }

    public OrderByList orderByActiveDesc(QueryContext ctx) {
        OrderByList result = ExecutionPlanSQLOps.oList(ExecutionPlanSQLOps.orderByDesc(ExecutionPlanSQLOps.exists(TaskInfo.getSelectForRunningPlans(this.ID))));
        result.add(this.orderByNameAsc(ctx));
        return result;
    }

    public OrderByList orderByNameAsc(QueryContext ctx) {
        FolderImplTable fT = new FolderImplTable("fT");
        ctx.addTable(fT);
        ctx.addAndWhereCondition(ExecutionPlanSQLOps.equals((ColumnNode)fT.ID, this.PathID));
        OrderByList result = ExecutionPlanSQLOps.dictOrderAsc(fT.FullPathString);
        result.add(ExecutionPlanSQLOps.dictOrderAsc(this.Name));
        result.add(this.orderByVersionDesc(ctx));
        return result;
    }

    public OrderByList orderByNameDesc(QueryContext ctx) {
        FolderImplTable fT = new FolderImplTable("fT");
        ctx.addTable(fT);
        ctx.addAndWhereCondition(ExecutionPlanSQLOps.equals((ColumnNode)fT.ID, this.PathID));
        OrderByList result = ExecutionPlanSQLOps.dictOrderDesc(fT.FullPathString);
        result.add(ExecutionPlanSQLOps.dictOrderDesc(this.Name));
        result.add(this.orderByVersionDesc(ctx));
        return result;
    }
}

