/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.plandb;

import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.util.NameRef;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentObserver;
import com.raplix.rolloutexpress.systemmodel.componentdb.MultiCompObserverQuery;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.folderdb.SummaryFolder;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlan;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanIDSet;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanImpl;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanObserver;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanToComponentNameRefTable;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanToExecutionPlanNameRefTable;
import com.raplix.rolloutexpress.systemmodel.plandb.MultiPlanObserverQuery;
import java.util.ArrayList;

class ExecutionPlanObserverQuery
implements MultiCompObserverQuery,
MultiPlanObserverQuery {
    private static ExecutionPlanObserverQuery sInstance = null;

    private ExecutionPlanObserverQuery() {
    }

    public static ExecutionPlanObserverQuery getInstance() {
        if (sInstance == null) {
            sInstance = new ExecutionPlanObserverQuery();
        }
        return sInstance;
    }

    public ComponentObserver[] selectCompObservers(String name, SummaryFolder path) throws PersistenceManagerException {
        try {
            String pathStr = path.getFullPathString();
            NameRef[] nrs = ExecutionPlanToComponentNameRefTable.DEFAULT.getByChildNameAndPath(name, pathStr);
            ExecutionPlanIDSet id = new ExecutionPlanIDSet();
            NameRef.parentIDSet(nrs, id);
            ExecutionPlan[] plans = id.getByIDsQuery().select();
            ArrayList<ExecutionPlanImpl> al = new ArrayList<ExecutionPlanImpl>();
            for (int i = 0; i < plans.length; ++i) {
                al.add(plans[i].getPlan());
            }
            return al.toArray(new ExecutionPlanImpl[0]);
        }
        catch (RPCException e) {
            throw new PersistenceManagerException(e);
        }
    }

    public ExecutionPlanObserver[] selectPlanObservers(String name, SummaryFolder path) throws PersistenceManagerException {
        try {
            String pathStr = path.getFullPathString();
            NameRef[] nrs = ExecutionPlanToExecutionPlanNameRefTable.DEFAULT.getByChildNameAndPath(name, pathStr);
            ExecutionPlanIDSet id = new ExecutionPlanIDSet();
            NameRef.parentIDSet(nrs, id);
            ExecutionPlan[] plans = id.getByIDsQuery().select();
            ArrayList<ExecutionPlanImpl> al = new ArrayList<ExecutionPlanImpl>();
            for (int i = 0; i < plans.length; ++i) {
                al.add(plans[i].getPlan());
            }
            return al.toArray(new ExecutionPlanImpl[0]);
        }
        catch (RPCException e) {
            throw new PersistenceManagerException(e);
        }
    }

    public void updateCompRefTable(String oldName, FolderID oldPath, String newName, SummaryFolder newPath) throws PersistenceManagerException {
        ExecutionPlanToComponentNameRefTable.DEFAULT.updateNameRefs(oldName, oldPath, newName, newPath);
    }

    public void updatePlanRefTable(String oldName, FolderID oldPath, String newName, SummaryFolder newPath) throws PersistenceManagerException {
        ExecutionPlanToExecutionPlanNameRefTable.DEFAULT.updateNameRefs(oldName, oldPath, newName, newPath);
    }
}

