/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.plandb;

import com.raplix.rolloutexpress.config.VariableSettingsSource;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.AcquireReadLockTransaction;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.VersionNumber;
import com.raplix.rolloutexpress.persist.VersionedPersistentBean;
import com.raplix.rolloutexpress.persist.VersionedSaveContext;
import com.raplix.rolloutexpress.persist.Visibility;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.util.Link;
import com.raplix.rolloutexpress.persist.util.NameRefSet;
import com.raplix.rolloutexpress.systemmodel.SystemModelParseException;
import com.raplix.rolloutexpress.systemmodel.XMLUtil;
import com.raplix.rolloutexpress.systemmodel.catdb.CategoryIDSet;
import com.raplix.rolloutexpress.systemmodel.catdb.CategoryUpdateContext;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentNameRefAdder;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentNameRefUpdater;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentObserver;
import com.raplix.rolloutexpress.systemmodel.componentdb.SummaryComponent;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.folderdb.SummaryFolder;
import com.raplix.rolloutexpress.systemmodel.plandb.Caller;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecStep;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionMode;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlan;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanData;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanID;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanIDSet;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanObserver;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanToComponentNameRefTable;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanToExecutionPlanNameRefTable;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanBody;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBException;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBPluginNSValidator;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBTransformer;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBVisitor;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanNameRefAdder;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanNameRefUpdater;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanToCategoryLinkTable;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanVarNStepValidator;
import com.raplix.rolloutexpress.systemmodel.plandb.PromptParamList;
import com.raplix.rolloutexpress.systemmodel.plandb.SummaryExecutionPlan;
import com.raplix.rolloutexpress.systemmodel.plugindb.Plugin;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginID;
import com.raplix.rolloutexpress.systemmodel.plugindb.SystemPluginConstants;
import com.raplix.rolloutexpress.systemmodel.userdb.UserID;
import com.raplix.util.ObjectUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.ecs.xml.XML;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class ExecutionPlanImpl
extends VersionedPersistentBean
implements Cloneable,
ComponentObserver,
ExecutionPlanObserver {
    static final String ELEMENT_NAME = "executionPlan";
    private static final String SCHEMA_NAME = "plan.xsd";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_PATH = "path";
    private static final String ATTR_DESC = "description";
    private String mName;
    private FolderID mPath = XMLUtil.DEFAULT_PATH;
    private String mFullName = null;
    private static final String DEFAULT_DESC = "";
    private String mDescription = "";
    private transient SummaryExecutionPlan mSummaryView;
    private boolean mExternalDataLoaded = false;
    private CategoryIDSet mCategoryIDSet;
    private String mBodyXML = null;
    private PlanBody mBody;
    private PluginID mPluginID;

    private ExecutionPlanImpl() {
    }

    static ExecutionPlanImpl create() {
        ExecutionPlanImpl result = new ExecutionPlanImpl();
        result.resetExternalData(true);
        result.mBody = new PlanBody();
        return result;
    }

    static ExecutionPlanImpl create(PluginID plugin) {
        ExecutionPlanImpl result = new ExecutionPlanImpl();
        result.resetExternalData(true);
        result.mBody = new PlanBody();
        result.setPluginID(plugin);
        return result;
    }

    ExecutionPlanID getID() {
        return (ExecutionPlanID)this.getObjectID();
    }

    ExecutionPlanID getRootID() {
        return (ExecutionPlanID)this.getRootObjectID();
    }

    protected UserID getUserID() {
        return super.getUserID();
    }

    protected Date getTimeStamp() {
        return super.getTimeStamp();
    }

    protected VersionNumber getVersionNumber() {
        return super.getVersionNumber();
    }

    String getName() {
        return this.mName;
    }

    void setName(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        this.mName = name;
        this.mFullName = null;
    }

    FolderID getPathID() {
        return this.mPath;
    }

    void setPathID(FolderID path) {
        if (path == null) {
            throw new NullPointerException();
        }
        this.mPath = path;
        this.mFullName = null;
    }

    String getFullName() {
        if (this.mFullName == null) {
            this.mFullName = this.getPathID().getFullPathString();
            if (this.getName() != null) {
                this.mFullName = this.mFullName + this.getName();
            }
        }
        return this.mFullName;
    }

    String getDescription() {
        return this.mDescription;
    }

    void setDescription(String desc) {
        if (desc == null) {
            throw new NullPointerException();
        }
        this.mDescription = desc;
    }

    private void resetDescription(String desc) {
        if (desc == null) {
            desc = DEFAULT_DESC;
        }
        this.mDescription = desc;
    }

    protected Visibility getVisibility() {
        return super.getVisibility();
    }

    protected void setVisibility(Visibility visibility) {
        super.setVisibility(visibility);
    }

    protected int getUpdateCount() {
        return super.getUpdateCount();
    }

    protected void setUpdateCount(int updateCount) {
        super.setUpdateCount(updateCount);
    }

    SummaryExecutionPlan getSummaryView() {
        if (this.mSummaryView == null) {
            this.mSummaryView = new SummaryExecutionPlan(this);
        }
        return this.mSummaryView;
    }

    ExecutionPlan getCompleteViewMS() throws PersistenceManagerException {
        this.loadExternalDataMS();
        return new ExecutionPlan(this);
    }

    private boolean isExternalDataLoaded() {
        return this.mExternalDataLoaded;
    }

    private void resetExternalData(boolean isLoadComplete) {
        this.mCategoryIDSet = new CategoryIDSet();
        if (isLoadComplete) {
            this.setExternalDataLoaded();
        }
    }

    private void setExternalDataLoaded() {
        this.mExternalDataLoaded = true;
    }

    private void loadExternalDataMS() throws PersistenceManagerException {
        if (this.isExternalDataLoaded()) {
            return;
        }
        if (this.getID() != null) {
            Link[] cats = PlanToCategoryLinkTable.DEFAULT.getByChildID(this.getID());
            this.setExternalDataMS(Arrays.asList(cats));
        } else {
            this.resetExternalData(true);
        }
    }

    static void loadExternalDataMS(List plans) throws PersistenceManagerException {
        int size = plans.size();
        if (size == 0) {
            return;
        }
        ExecutionPlanIDSet idSet = new ExecutionPlanIDSet();
        for (int i = 0; i < size; ++i) {
            ExecutionPlanImpl plan = (ExecutionPlanImpl)plans.get(i);
            if (plan.isExternalDataLoaded()) continue;
            idSet.add(plan.getID());
        }
        if (idSet.isEmpty()) {
            return;
        }
        ObjectID[] planIDs = idSet.toIDArray();
        Map catMap = PlanToCategoryLinkTable.DEFAULT.mapLinksByChildIDs(planIDs);
        for (int i = 0; i < size; ++i) {
            ExecutionPlanImpl plan = (ExecutionPlanImpl)plans.get(i);
            if (plan.isExternalDataLoaded()) continue;
            List catList = (List)catMap.get(plan.getID());
            plan.setExternalDataMS(catList);
        }
    }

    private synchronized void setExternalDataMS(List catList) throws SystemModelParseException {
        if (this.isExternalDataLoaded()) {
            return;
        }
        this.resetExternalData(false);
        Link.addParentIDs(this.mCategoryIDSet, catList);
        this.initBodyFromXML();
        this.setExternalDataLoaded();
    }

    CategoryIDSet getCategories() {
        return (CategoryIDSet)this.mCategoryIDSet.clone();
    }

    void setCategories(CategoryIDSet set) {
        this.mCategoryIDSet = (CategoryIDSet)set.clone();
    }

    private String getBodyXML() {
        return this.mBodyXML;
    }

    private void setBodyXML(String xml) {
        this.mBodyXML = xml;
    }

    PlanBody getBody() {
        return this.mBody;
    }

    private void setBody(PlanBody body) {
        this.mBody = body;
    }

    String getSchemaVersion() {
        return this.getBody().getSchemaVersion();
    }

    void setSchemaVersion(String inValue) {
        this.getBody().setSchemaVersion(inValue);
    }

    ExecutionMode getExecutionMode() {
        return this.getBody().getExecutionMode();
    }

    void setExecutionMode(ExecutionMode executionMode) {
        this.getBody().setExecutionMode(executionMode);
    }

    String getLimitToHostSet() {
        return this.getBody().getLimitToHostSet();
    }

    void setLimitToHostSet(String name) {
        this.getBody().setLimitToHostSet(name);
    }

    PromptParamList getParams() {
        return this.getBody().getParams();
    }

    void setParams(PromptParamList params) {
        this.getBody().setParams(params);
    }

    VariableSettingsSource getLocalVars() {
        return this.getBody().getLocalVars();
    }

    void setLocalVars(VariableSettingsSource localVars) {
        this.getBody().setLocalVars(localVars);
    }

    boolean isCompositePlan() {
        return this.getBody().isCompositePlan();
    }

    boolean isSimplePlan() {
        return this.getBody().isSimplePlan();
    }

    ExecStep[] getExecSteps() {
        return this.getBody().getExecSteps();
    }

    void setExecSteps(ExecStep[] inSteps) {
        this.getBody().setExecSteps(inSteps);
    }

    void readFromXML(String inString) throws SystemModelParseException, PlanDBException {
        this.readFromXML(this.toInputSource(inString), false);
    }

    private InputSource toInputSource(String s) {
        return new InputSource(new StringReader(s));
    }

    void readFromXML(InputStream inStream, boolean createFolder) throws SystemModelParseException, PlanDBException {
        this.readFromXML(new InputSource(inStream), createFolder);
    }

    private void readFromXML(InputSource inputSource, boolean createFolder) throws SystemModelParseException, PlanDBException {
        Element topElement = this.parseInputSource(inputSource, true);
        this.setName(topElement.getAttribute(ATTR_NAME));
        this.setPathID(XMLUtil.getPathAttribute(topElement, ATTR_PATH, "pdb.", createFolder));
        this.resetDescription(topElement.getAttribute(ATTR_DESC));
        this.setBody(new PlanBody(topElement));
        this.validateContent();
    }

    private Element parseInputSource(InputSource input, boolean reportErrors) throws SystemModelParseException {
        DOMParser parser = XMLUtil.obtainParser(reportErrors, SCHEMA_NAME, "pdb.");
        try {
            parser.parse(input);
            return parser.getDocument().getDocumentElement();
        }
        catch (IOException e) {
            throw this.newParseError(e);
        }
        catch (SAXException e) {
            throw this.newParseError(e);
        }
    }

    private SystemModelParseException newParseError(Exception e) {
        return new SystemModelParseException(e, "pdb.");
    }

    private void initBodyFromXML() throws SystemModelParseException {
        Element topElement = this.parseInputSource(this.toInputSource(this.getBodyXML()), false);
        this.setBody(new PlanBody(topElement));
    }

    String writeToXML() {
        String sep = System.getProperty("line.separator");
        return XMLUtil.getXMLHeaderString() + this.writeToXMLElement().toString() + sep;
    }

    void writeToXML(OutputStream out) {
        XMLUtil.writeXMLHeader(out);
        this.writeToXMLElement().output(out);
        new PrintWriter(out, true).println();
    }

    private XML writeToXMLElement() {
        XML thisElement = new XML(ELEMENT_NAME);
        thisElement.setPrettyPrint(true);
        XMLUtil.addSchemaAttributes(thisElement, SCHEMA_NAME);
        XMLUtil.addPathAttribute(thisElement, ATTR_PATH, this.getPathID());
        ExecStep.addAttributeIfNotNull(thisElement, ATTR_NAME, this.getName());
        String desc = this.getDescription();
        if (!DEFAULT_DESC.equals(desc)) {
            ExecStep.addAttributeIfNotNull(thisElement, ATTR_DESC, desc);
        }
        this.getBody().writeToXML(thisElement);
        return thisElement;
    }

    private void writeBodyToXML() {
        XML bodyXML = new XML(ELEMENT_NAME);
        this.getBody().writeToXML(bodyXML);
        this.setBodyXML(XMLUtil.getXMLForDB(bodyXML));
    }

    protected Object clone() {
        try {
            ExecutionPlanImpl result = (ExecutionPlanImpl)super.clone();
            result.mSummaryView = null;
            result.mBody = (PlanBody)result.mBody.clone();
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    protected Object getObjectDataClone() {
        try {
            ExecutionPlanImpl result = (ExecutionPlanImpl)super.getObjectDataClone();
            result.setPluginID(null);
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    void save(VersionedSaveContext ctx) throws PersistenceManagerException, RPCException {
        this.validate();
        this.saveRPC(ctx);
    }

    protected void saveMS(final VersionedSaveContext context) throws PersistenceManagerException {
        ExecutionPlanImpl.transactMS(new AcquireReadLockTransaction(){

            public Object execute() throws PersistenceManagerException {
                ExecutionPlanImpl.this.executeSaveMS(context);
                return null;
            }

            public ROXMessage getLockDescription() {
                return new ROXMessage("pdb.SAVING_PLAN", ExecutionPlanImpl.this.getFullName());
            }
        });
    }

    private void executeSaveMS(VersionedSaveContext context) throws PersistenceManagerException {
        ExecutionPlanID.verifyPerms(this.getSummaryView(), null, false);
        this.validateMS();
        this.writeBodyToXML();
        super.saveMS(context);
    }

    protected void saveSameVersionMS() throws PersistenceManagerException {
        this.writeBodyToXML();
        super.saveSameVersionMS();
    }

    protected void trSaveMS(VersionedPersistentBean latest, VersionedSaveContext ctx) throws PersistenceManagerException {
        super.trSaveMS(latest, ctx);
        PlanToCategoryLinkTable.DEFAULT.updateCategoriesMS(this.getID(), new CategoryUpdateContext(this.mCategoryIDSet), this.getID().equals(this.getRootID()));
        this.incrementUpdateCountInSave();
        ExecutionPlan ep = this.getCompleteViewMS();
        NameRefSet set = new NameRefSet();
        ep.addComponentRefsMS(set);
        ExecutionPlanToComponentNameRefTable.DEFAULT.addReferences(this.getID(), set);
        set = new NameRefSet();
        ep.addPlanRefsMS(set);
        ExecutionPlanToExecutionPlanNameRefTable.DEFAULT.addReferences(this.getID(), set);
    }

    void validate() throws SystemModelParseException, PlanDBException {
        ExecutionPlan.validateName(this.getName());
        String xml = this.writeToXML();
        ExecutionPlan temp = new ExecutionPlan();
        temp.readFromXML(xml);
    }

    private void validateMS() throws PersistenceManagerException {
        try {
            this.validateName();
            this.validateNamespaceMS();
        }
        catch (RPCException e) {
            throw PlanDBException.unexpectedRPCError(e);
        }
    }

    private void validateName() throws PersistenceManagerException, RPCException {
        SummaryExecutionPlan rootPlan;
        String rootName;
        ExecutionPlanID rootID = this.getRootID();
        if (rootID != null && !(rootName = (rootPlan = rootID.getByIDQuery().selectSummaryView()).getFullName()).equals(this.getFullName())) {
            throw PlanDBException.nameMustMatchRoot(rootName);
        }
    }

    private void validateContent() throws PlanDBException {
        PlanVarNStepValidator validator = new PlanVarNStepValidator(this.toCaller());
        try {
            validator.visit(this);
        }
        catch (Exception e) {
            throw validator.mapException(e);
        }
    }

    public boolean equalsPlanData(ExecutionPlanData otherPlan) {
        if (otherPlan == null) {
            return false;
        }
        PlanBody body = this.getBody();
        if (otherPlan instanceof ExecutionPlan) {
            ExecutionPlan otherExecPlan = (ExecutionPlan)otherPlan;
            if (!(body.getParams().equals(otherExecPlan.getParams()) && this.getPathID().equals(otherExecPlan.getPath()) && ObjectUtil.equals(this.getSchemaVersion(), otherExecPlan.getSchemaVersion()))) {
                return false;
            }
        }
        return ObjectUtil.equals(this.getName(), otherPlan.getName()) && ObjectUtil.equals(this.getDescription(), otherPlan.getDescription()) && body.equalsPlanData(otherPlan);
    }

    PluginID getPluginID() {
        return this.mPluginID;
    }

    private void setPluginID(PluginID plugin) {
        this.mPluginID = plugin;
    }

    public void addComponentRefsMS(NameRefSet set) throws PersistenceManagerException {
        ComponentNameRefAdder adder = new ComponentNameRefAdder(set, this.toCaller());
        try {
            adder.getPlanDBVisitor().visit(this);
        }
        catch (Exception e) {
            throw adder.mapException(e);
        }
    }

    ExecutionPlanImpl updateComponentRefsMS(SummaryComponent sc, String newName, SummaryFolder newPath) throws PersistenceManagerException {
        ComponentNameRefUpdater updater = new ComponentNameRefUpdater(sc, this.toCaller(), newName, newPath);
        try {
            return updater.getPlanDBTransformer().transform(this);
        }
        catch (Exception e) {
            throw updater.mapException(e);
        }
    }

    void addPlanRefsMS(NameRefSet set) throws PersistenceManagerException {
        PlanNameRefAdder adder = new PlanNameRefAdder(set, this.toCaller());
        try {
            adder.visit(this);
        }
        catch (Exception e) {
            throw adder.mapException(e);
        }
        set.addNameRef(this.getName(), this.getPathID().getFullPathString());
    }

    ExecutionPlanImpl updatePlanRefsMS(SummaryExecutionPlan ep, String newName, SummaryFolder newPath) throws PersistenceManagerException {
        ExecutionPlanImpl result;
        PlanNameRefUpdater updater = new PlanNameRefUpdater(ep, this.toCaller(), newName, newPath);
        try {
            result = updater.transform(this);
        }
        catch (Exception e) {
            throw updater.mapException(e);
        }
        if (this.getRootID().equals(ep.getRootID())) {
            if (newName != null) {
                result.setName(newName);
            }
            if (newPath != null) {
                result.setPathID(newPath.getID());
            }
        }
        return result;
    }

    void accept(PlanDBVisitor v) throws Exception {
        v.visit(this.getBody());
    }

    ExecutionPlanImpl accept(PlanDBTransformer t) throws Exception {
        ExecutionPlanImpl result = t.clone(this);
        result.setBody(t.transform(this.getBody()));
        return result;
    }

    ExecutionPlanImpl cloneForTransform() {
        return (ExecutionPlanImpl)this.clone();
    }

    public void renameComponent(SummaryComponent sc, String name, SummaryFolder path) throws PersistenceManagerException, RPCException {
        this.updateComponentRefsMS(sc, name, path).saveSameVersionMS();
    }

    public void renamePlan(SummaryExecutionPlan sep, String name, SummaryFolder path) throws PersistenceManagerException, RPCException {
        this.updatePlanRefsMS(sep, name, path).saveSameVersionMS();
    }

    boolean isMoveNeeded(String name, SummaryFolder path) {
        if (name == null) {
            if (path == null) {
                return false;
            }
            if (this.getPathID() != null && this.getPathID().getFullPathString().equals(path.getFullPathString())) {
                return false;
            }
        } else if (this.getName().equals(name)) {
            if (path == null) {
                return false;
            }
            if (this.getPathID() != null && this.getPathID().getFullPathString().equals(path.getFullPathString())) {
                return false;
            }
        }
        return true;
    }

    private Caller toCaller() {
        return this.getSummaryView().toCaller();
    }

    private void validateNamespaceMS() throws PersistenceManagerException, RPCException {
        SummaryExecutionPlan root;
        PluginID plid = this.getPluginID();
        if (this.getRootID() != null && !ObjectUtil.equals(plid, (root = this.getRootID().getByIDQuery().selectSummaryView()).getPluginID())) {
            throw PlanDBException.pluginMustMatchRoot();
        }
        SummaryFolder psf = this.getPathID().getByIDQuery().selectSummaryView();
        ExecutionPlanID.verifyFolder(this.getSummaryView(), psf);
        if (this.isAutoGen()) {
            return;
        }
        if (plid != null) {
            Plugin p = plid.getByIDQuery().select();
            p.validateNamespace(this.getPluginID(), this.getFullName(), ELEMENT_NAME);
            PlanDBPluginNSValidator nv = new PlanDBPluginNSValidator(p, this.toCaller());
            try {
                nv.visit(this);
            }
            catch (Exception e) {
                throw nv.mapException(e);
            }
            nv.visitHostSet(this.getLimitToHostSet());
        }
    }

    private boolean isAutoGen() throws PersistenceManagerException, RPCException {
        return this.getPathID().equals(SystemPluginConstants.getInstance().AUTOGEN_FOLDER_ID);
    }
}

