/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.plandb;

import com.raplix.rolloutexpress.executor.AutoGeneratedPlan;
import com.raplix.rolloutexpress.executor.AutoGeneratedPlanTable;
import com.raplix.rolloutexpress.executor.SubplanInfo;
import com.raplix.rolloutexpress.executor.SubplanInfoTable;
import com.raplix.rolloutexpress.executor.TaskInfoTable;
import com.raplix.rolloutexpress.executor.query.MultiAutoGenPlanQuery;
import com.raplix.rolloutexpress.executor.query.MultiRunningPlanQuery;
import com.raplix.rolloutexpress.executor.query.MultiSubplanInfoQuery;
import com.raplix.rolloutexpress.executor.query.MultiTaskInfoQuery;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.AcquireWriteLockRPCTransaction;
import com.raplix.rolloutexpress.persist.DeleteSessionContext;
import com.raplix.rolloutexpress.persist.DeleteSessionDependentContainer;
import com.raplix.rolloutexpress.persist.HasObjectID;
import com.raplix.rolloutexpress.persist.IDResolvingTypedSet;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.ObjectIDFactory;
import com.raplix.rolloutexpress.persist.PersistContext;
import com.raplix.rolloutexpress.persist.UsingObject;
import com.raplix.rolloutexpress.persist.VersionedObjectID;
import com.raplix.rolloutexpress.persist.Visibility;
import com.raplix.rolloutexpress.persist.cache.ObjectCache;
import com.raplix.rolloutexpress.persist.cache.SingleVersionedObjectByFullNameCache;
import com.raplix.rolloutexpress.persist.exception.ObjectInUseException;
import com.raplix.rolloutexpress.persist.exception.ObjectNotDeletableException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.map.ClassMap;
import com.raplix.rolloutexpress.persist.query.ObjectFilter;
import com.raplix.rolloutexpress.persist.query.QueryContext;
import com.raplix.rolloutexpress.systemmodel.catdb.CategoryUpdateContext;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentID;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.folderdb.SummaryFolder;
import com.raplix.rolloutexpress.systemmodel.installdb.PersistentInstalledComponentTable;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanIDSet;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanImplTable;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanObserver;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanObserverQuery;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanToComponentNameRefTable;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanToExecutionPlanNameRefTable;
import com.raplix.rolloutexpress.systemmodel.plandb.MultiExecutionPlanQuery;
import com.raplix.rolloutexpress.systemmodel.plandb.MultiPlanObserverQuery;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBException;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanToCategoryLinkTable;
import com.raplix.rolloutexpress.systemmodel.plandb.SingleExecutionPlanQuery;
import com.raplix.rolloutexpress.systemmodel.plandb.SummaryExecutionPlan;
import com.raplix.rolloutexpress.systemmodel.plugindb.Plugin;
import com.raplix.rolloutexpress.systemmodel.userdb.FolderPermission;
import com.raplix.util.ObjectUtil;
import java.security.AccessControlException;
import java.security.AccessController;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;

public class ExecutionPlanID
extends VersionedObjectID {
    public static final ExecutionPlanID PLAN_SENTINEL_ID = new ExecutionPlanID("010010001019-0000000000000-00009-0000000001");
    private static IDFactory ID_FACTORY = new IDFactory();
    private static Vector sObserverQueries = new Vector();

    private ExecutionPlanID() {
    }

    public ExecutionPlanID(String sID) {
        super(sID);
    }

    public static ExecutionPlanID generateID() {
        return (ExecutionPlanID)ID_FACTORY.generateObjectID();
    }

    public void updateVisibility(Visibility inVisibility) throws PersistenceManagerException, RPCException {
        this.updateVisibilityRPC(inVisibility, null);
    }

    public SingleExecutionPlanQuery getByIDQuery() {
        return new SingleExecutionPlanQuery(this);
    }

    public MultiExecutionPlanQuery getAllVersionsQuery() {
        return MultiExecutionPlanQuery.allVersionsOf(this);
    }

    public int updateCategories(CategoryUpdateContext ctx) throws PersistenceManagerException, RPCException {
        return PlanToCategoryLinkTable.DEFAULT.updateCategories(this, ctx);
    }

    public void findDependentObjects(DeleteSessionContext inContext, DeleteSessionDependentContainer inDependentContainer, DeleteSessionDependentContainer inPostDependentContainer) throws PersistenceManagerException {
        try {
            if (PLAN_SENTINEL_ID.equals(this)) {
                throw new ObjectNotDeletableException(new ROXMessage("pm.CANNOT_DELETE_OBJECT"));
            }
            MultiRunningPlanQuery mrpq = MultiRunningPlanQuery.allPlans();
            mrpq.addFilter(new ObjectFilter(){

                public void addFilterCondition(QueryContext ctx) {
                    ExecutionPlanImplTable t = (ExecutionPlanImplTable)ctx.getFirstTable();
                    ctx.addAndWhereCondition(ExecutionPlanImplTable.equals(t.ID, ExecutionPlanID.this));
                }
            });
            UsingObject[] plans = mrpq.select();
            if (plans.length > 0 && plans[0].getIsRunning()) {
                throw new ObjectInUseException(new ROXMessage("pm.OBJECT_IN_USE"), plans);
            }
            this.checkVersionedObjectInUse(inContext);
            MultiAutoGenPlanQuery autoGenPlanQuery = MultiAutoGenPlanQuery.all();
            autoGenPlanQuery.addFilter(new ObjectFilter(){

                public void addFilterCondition(QueryContext ctx) {
                    AutoGeneratedPlanTable t = (AutoGeneratedPlanTable)ctx.getFirstTable();
                    ctx.addAndWhereCondition(AutoGeneratedPlanTable.equals(t.PlanID, ExecutionPlanID.this));
                }
            });
            HasObjectID[] agPlans = (AutoGeneratedPlan[])autoGenPlanQuery.selectObjects();
            if (agPlans.length > 0) {
                HashSet<ComponentID> compsChecked = new HashSet<ComponentID>();
                for (int i = 0; i < agPlans.length; ++i) {
                    if (compsChecked.contains(agPlans[i].getComponentID())) continue;
                    FolderPermission fp = new FolderPermission(agPlans[i].getComponentID().getByIDQuery().selectSummaryView().getPath(), "write");
                    try {
                        AccessController.checkPermission(fp);
                    }
                    catch (AccessControlException e) {
                        throw new ObjectNotDeletableException(fp.getMessage());
                    }
                    compsChecked.add(agPlans[i].getComponentID());
                }
            } else {
                SummaryExecutionPlan thePlan = this.getByIDQuery().selectSummaryView();
                try {
                    Plugin.checkWritePermissions(thePlan);
                }
                catch (AccessControlException e) {
                    throw new ObjectInUseException(new ROXMessage("pm.OBJECT_IN_USE"), new UsingObject[]{thePlan.getPluginID().getByIDQuery().selectSummaryView()});
                }
                FolderPermission fp = new FolderPermission(thePlan.getPath(), "write");
                try {
                    AccessController.checkPermission(fp);
                }
                catch (AccessControlException e) {
                    throw new ObjectNotDeletableException(fp.getMessage());
                }
            }
            MultiSubplanInfoQuery subplanInfoQuery = MultiSubplanInfoQuery.all();
            subplanInfoQuery.addFilter(new ObjectFilter(){

                public void addFilterCondition(QueryContext ctx) {
                    SubplanInfoTable t = (SubplanInfoTable)ctx.getFirstTable();
                    ctx.addAndWhereCondition(SubplanInfoTable.equals(t.SubplanID, ExecutionPlanID.this));
                }
            });
            SubplanInfo[] subs = subplanInfoQuery.select();
            if (subs != null) {
                for (int i = 0; i < subs.length; ++i) {
                    inDependentContainer.addDependentObject(subs[i].getTaskID().getByIDQuery().select());
                }
            }
            MultiTaskInfoQuery taskInfoQuery = MultiTaskInfoQuery.all();
            taskInfoQuery.addFilter(new ObjectFilter(){

                public void addFilterCondition(QueryContext ctx) {
                    TaskInfoTable t = (TaskInfoTable)ctx.getFirstTable();
                    ctx.addAndWhereCondition(TaskInfoTable.equals(t.PlanID, ExecutionPlanID.this));
                }
            });
            inDependentContainer.addAllDependentObjects(taskInfoQuery.selectObjects());
            inDependentContainer.addAllDependentObjects(agPlans);
        }
        catch (RPCException rpce) {
            throw new PersistenceManagerException(rpce);
        }
    }

    protected IDResolvingTypedSet getIDResolvingTypedSet() throws PersistenceManagerException {
        ExecutionPlanIDSet idset = new ExecutionPlanIDSet();
        idset.add(this);
        return idset;
    }

    protected void deleteMS(PersistContext context) throws PersistenceManagerException {
        PlanToCategoryLinkTable.DEFAULT.removeByChildID(this);
        PersistentInstalledComponentTable ct = PersistentInstalledComponentTable.DEFAULT;
        PersistentInstalledComponentTable.execute(PersistentInstalledComponentTable.update(ct, PersistentInstalledComponentTable.uList(PersistentInstalledComponentTable.set(ct.PlanID, PLAN_SENTINEL_ID)), PersistentInstalledComponentTable.where(PersistentInstalledComponentTable.equals(ct.PlanID, this))));
        ExecutionPlanToComponentNameRefTable.DEFAULT.removeByParentID(this);
        ExecutionPlanToExecutionPlanNameRefTable.DEFAULT.removeByParentID(this);
        super.deleteMS(context);
    }

    public void move(String name, FolderID path) throws PersistenceManagerException, RPCException, AccessControlException {
        ExecutionPlanID.move(this, name, path);
    }

    static void move(final ExecutionPlanID plan, final String name, final FolderID path) throws RPCException, PersistenceManagerException {
        if (name == null && path == null) {
            return;
        }
        ExecutionPlanID.transactRPC(new AcquireWriteLockRPCTransaction(){

            protected PersistContext executeMS() throws PersistenceManagerException {
                try {
                    SummaryFolder f = path == null ? null : path.getByIDQuery().selectSummaryView();
                    ExecutionPlanID.trMoveMS(plan, name, f);
                    return null;
                }
                catch (RPCException e) {
                    throw new PersistenceManagerException(e);
                }
            }

            public ROXMessage getLockDescription() {
                return new ROXMessage("pdb.MOVING_PLANS");
            }
        });
    }

    static void trMoveMS(ExecutionPlanID planId, String name, SummaryFolder path) throws PersistenceManagerException {
        if (name == null && path == null) {
            return;
        }
        try {
            SummaryExecutionPlan plan = planId.getByIDQuery().selectSummaryView();
            if (!plan.isMoveNeeded(name, path)) {
                return;
            }
            boolean isFolderMove = path != null && plan.getPath().equals(path.getID());
            SummaryFolder planPath = plan.getPath().getByIDQuery().selectSummaryView();
            ExecutionPlanID.validateMove(plan, name, path, isFolderMove);
            Iterator iter = sObserverQueries.iterator();
            while (iter.hasNext()) {
                MultiPlanObserverQuery next = (MultiPlanObserverQuery)iter.next();
                ExecutionPlanObserver[] po = next.selectPlanObservers(plan.getName(), planPath);
                for (int j = 0; j < po.length; ++j) {
                    po[j].renamePlan(plan, name, path);
                }
                String updateName = name == null ? plan.getName() : name;
                SummaryFolder updatePath = path == null ? planPath : path;
                next.updatePlanRefTable(plan.getName(), plan.getPath(), updateName, updatePath);
            }
        }
        catch (RPCException e) {
            throw new PersistenceManagerException(e);
        }
    }

    private static void validateMove(SummaryExecutionPlan plan, String name, SummaryFolder path, boolean isFolderMove) throws PlanDBException, PersistenceManagerException, RPCException {
        if (!isFolderMove) {
            FolderID qPath;
            String qName = name == null ? plan.getName() : name;
            FolderID folderID = qPath = path == null ? plan.getPath() : path.getID();
            if (SingleExecutionPlanQuery.byName(qPath, qName, null).selectExists()) {
                throw PlanDBException.nameCollision(plan.getFullName(), qName, qPath.getFullPathString());
            }
        }
        ExecutionPlanID.verifyPerms(plan, path, isFolderMove);
        if (path != null) {
            ExecutionPlanID.verifyFolder(plan, path);
        }
    }

    static void verifyFolder(SummaryExecutionPlan plan, SummaryFolder path) throws PlanDBException {
        if (!ObjectUtil.equals(plan.getPluginID(), path.getPluginID())) {
            throw PlanDBException.pluginMustMatchFolder(plan, path);
        }
    }

    static void verifyPerms(SummaryExecutionPlan plan, SummaryFolder newPath, boolean isFolderMove) throws AccessControlException {
        Plugin.checkWritePermissions(plan);
        if (!isFolderMove) {
            AccessController.checkPermission(new FolderPermission(plan.getPath(), "write"));
            if (newPath != null) {
                AccessController.checkPermission(new FolderPermission(newPath.getID(), "write"));
            }
        }
    }

    public static void registerObserverQuery(MultiPlanObserverQuery query) {
        sObserverQueries.add(query);
    }

    public static class IDFactory
    extends ObjectIDFactory {
        protected ObjectID newInstance(String inID) {
            return new ExecutionPlanID(inID);
        }

        public void registerCaches(ClassMap classMap, ObjectCache objectCache) {
            ExecutionPlanImplTable t = ExecutionPlanImplTable.DEFAULT;
            SingleVersionedObjectByFullNameCache cache = new SingleVersionedObjectByFullNameCache(objectCache, t.PathID, t.Name, t.Version);
            classMap.addSingleObjectCache(cache);
            ExecutionPlanID.registerObserverQuery(ExecutionPlanObserverQuery.getInstance());
            ComponentID.registerObserverQuery(ExecutionPlanObserverQuery.getInstance());
        }
    }
}

