/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.plandb;

import com.raplix.rolloutexpress.config.VariableSettingsSource;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.VersionedSaveContext;
import com.raplix.rolloutexpress.persist.Visibility;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.util.NameRefSet;
import com.raplix.rolloutexpress.systemmodel.SystemModelParseException;
import com.raplix.rolloutexpress.systemmodel.XMLUtil;
import com.raplix.rolloutexpress.systemmodel.catdb.CategoryIDSet;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentReferrer;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecStep;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionMode;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanData;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanImpl;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanReferrer;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBException;
import com.raplix.rolloutexpress.systemmodel.plandb.PromptParamList;
import com.raplix.rolloutexpress.systemmodel.plandb.SummaryExecutionPlan;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginID;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.xerces.impl.dv.InvalidDatatypeValueException;

public class ExecutionPlan
extends SummaryExecutionPlan
implements ExecutionPlanData,
Cloneable,
ComponentReferrer,
ExecutionPlanReferrer {
    private boolean mPlanIsCopy;

    public ExecutionPlan() {
        super(ExecutionPlanImpl.create());
        this.mPlanIsCopy = true;
    }

    public ExecutionPlan(PluginID plugin) {
        super(ExecutionPlanImpl.create(plugin));
        this.mPlanIsCopy = true;
    }

    ExecutionPlan(ExecutionPlanImpl plan) {
        super(plan);
        this.mPlanIsCopy = false;
    }

    ExecutionPlanImpl getMutablePlan() {
        if (!this.mPlanIsCopy) {
            this.setPlan((ExecutionPlanImpl)this.getPlan().clone());
            this.mPlanIsCopy = true;
        }
        return this.getPlan();
    }

    public void setName(String name) {
        this.getMutablePlan().setName(name);
    }

    public void setPath(FolderID path) {
        this.getMutablePlan().setPathID(path);
    }

    public void setDescription(String desc) {
        this.getMutablePlan().setDescription(desc);
    }

    public String getSchemaVersion() {
        return this.getPlan().getSchemaVersion();
    }

    public void setSchemaVersion(String inValue) {
        this.getMutablePlan().setSchemaVersion(inValue);
    }

    public ExecutionMode getExecutionMode() {
        return this.getPlan().getExecutionMode();
    }

    public void setExecutionMode(ExecutionMode executionMode) {
        this.getMutablePlan().setExecutionMode(executionMode);
    }

    public String getLimitToHostSet() {
        return this.getPlan().getLimitToHostSet();
    }

    public void setLimitToHostSet(String name) {
        this.getMutablePlan().setLimitToHostSet(name);
    }

    public PromptParamList getParams() {
        return this.getPlan().getParams();
    }

    public void setParams(PromptParamList params) {
        this.getMutablePlan().setParams(params);
    }

    public VariableSettingsSource getLocalVars() {
        return this.getPlan().getLocalVars();
    }

    public void setLocalVars(VariableSettingsSource localVars) {
        this.getMutablePlan().setLocalVars(localVars);
    }

    public boolean isCompositePlan() {
        return this.getPlan().isCompositePlan();
    }

    public boolean isSimplePlan() {
        return this.getPlan().isSimplePlan();
    }

    public ExecStep[] getExecSteps() {
        return this.getPlan().getExecSteps();
    }

    public void setExecSteps(ExecStep[] inSteps) {
        this.getMutablePlan().setExecSteps(inSteps);
    }

    public CategoryIDSet getCategories() {
        return this.getPlan().getCategories();
    }

    public void setCategories(CategoryIDSet cats) {
        this.getMutablePlan().setCategories(cats);
    }

    public void setVisibility(Visibility visibility) {
        this.getMutablePlan().setVisibility(visibility);
    }

    public void setUpdateCount(int updateCount) {
        this.getMutablePlan().setUpdateCount(updateCount);
    }

    public void readFromXML(String inString) throws SystemModelParseException, PlanDBException {
        this.getMutablePlan().readFromXML(inString);
    }

    public void readFromXML(InputStream inStream) throws SystemModelParseException, PlanDBException {
        this.getMutablePlan().readFromXML(inStream, false);
    }

    void readFromXML(InputStream inStream, boolean createFolder) throws SystemModelParseException, PlanDBException {
        this.getMutablePlan().readFromXML(inStream, createFolder);
    }

    public String writeToXML() {
        return this.getPlan().writeToXML();
    }

    public void writeToXML(OutputStream out) {
        this.getPlan().writeToXML(out);
    }

    public ExecutionPlan getDataClone() {
        return new ExecutionPlan((ExecutionPlanImpl)this.getPlan().getObjectDataClone());
    }

    public Object clone() {
        if (this.mPlanIsCopy) {
            return new ExecutionPlan((ExecutionPlanImpl)this.getPlan().clone());
        }
        return new ExecutionPlan(this.getPlan());
    }

    public void save(VersionedSaveContext ctx) throws PersistenceManagerException, RPCException {
        this.getMutablePlan().save(ctx);
    }

    void saveSameVersionMS() throws PersistenceManagerException {
        this.getMutablePlan().saveSameVersionMS();
    }

    public void validate() throws SystemModelParseException, PlanDBException {
        this.getPlan().validate();
    }

    public static void validateName(String name) throws SystemModelParseException, PlanDBException {
        if (name == null) {
            throw PlanDBException.invalidPlanName(name);
        }
        try {
            XMLUtil.validateEntityName(name);
        }
        catch (InvalidDatatypeValueException e) {
            throw PlanDBException.invalidPlanName(name);
        }
    }

    public boolean equalsPlanData(ExecutionPlanData otherPlan) {
        return this.getPlan().equalsPlanData(otherPlan);
    }

    public void addComponentRefsMS(NameRefSet set) throws PersistenceManagerException {
        this.getPlan().addComponentRefsMS(set);
    }

    public void addPlanRefsMS(NameRefSet set) throws PersistenceManagerException {
        this.getPlan().addPlanRefsMS(set);
    }
}

