/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.plandb;

import com.raplix.rolloutexpress.config.ConfigGenException;
import com.raplix.rolloutexpress.config.ConfigGenerator;
import com.raplix.rolloutexpress.config.VariableSettingsSource;
import com.raplix.rolloutexpress.systemmodel.SystemModelParseException;
import com.raplix.rolloutexpress.systemmodel.folderdb.SummaryFolder;
import com.raplix.rolloutexpress.systemmodel.plandb.AggregateStep;
import com.raplix.rolloutexpress.systemmodel.plandb.ArgList;
import com.raplix.rolloutexpress.systemmodel.plandb.Caller;
import com.raplix.rolloutexpress.systemmodel.plandb.CompositePlanStep;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecStep;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBPluginNSValidator;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBTransformer;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBVisitor;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanNameRefAdder;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanNameRefUpdater;
import com.raplix.rolloutexpress.systemmodel.plandb.SingleExecutionPlanQuery;
import com.raplix.rolloutexpress.systemmodel.plandb.SummaryExecutionPlan;
import org.apache.ecs.xml.XML;
import org.w3c.dom.Element;

public class ExecSubplanStep
extends ExecStep
implements CompositePlanStep,
AggregateStep {
    public static final String ELEMENT_NAME = "execSubplan";
    private static final String PATH_ATTR = "planPath";
    private static final String NAME_ATTR = "planName";
    private static final String VERSION_ATTR = "planVersion";
    protected String mPlanPath;
    protected String mPlanName;
    protected String mPlanVersion;
    private ArgList mArgs;

    private ExecSubplanStep() {
    }

    public ExecSubplanStep(Element inElement) throws SystemModelParseException {
        super(inElement);
        this.setPlanPath(ExecSubplanStep.getAttribute(inElement, PATH_ATTR));
        this.mPlanName = inElement.getAttribute(NAME_ATTR);
        this.setPlanVersion(ExecSubplanStep.getAttribute(inElement, VERSION_ATTR));
        this.mArgs = new ArgList(inElement);
    }

    public ExecSubplanStep(String inPlanName, String inPlanVersion) {
        this(null, inPlanName, inPlanVersion, new ArgList());
    }

    public ExecSubplanStep(String inPlanPath, String inPlanName, String inPlanVersion, VariableSettingsSource args) {
        this.setPlanPath(inPlanPath);
        this.mPlanName = inPlanName;
        this.setPlanVersion(inPlanVersion);
        this.setArgs(args);
    }

    public String getPlanPath() {
        return this.mPlanPath;
    }

    private void setPlanPath(String path) {
        this.mPlanPath = path;
    }

    public String getPlanName() {
        return this.mPlanName;
    }

    public void setPlanName(String inValue) {
        this.mPlanName = inValue;
    }

    public String getPlanVersion() {
        return this.mPlanVersion;
    }

    public void setPlanVersion(String inValue) {
        if ("".equals(inValue)) {
            inValue = null;
        }
        this.mPlanVersion = inValue;
    }

    public VariableSettingsSource getArgs() {
        return (VariableSettingsSource)this.mArgs.clone();
    }

    private void setArgs(VariableSettingsSource args) {
        this.mArgs = new ArgList(args);
    }

    public ExecStep generate(ConfigGenerator generator) throws ConfigGenException {
        ExecSubplanStep result = (ExecSubplanStep)super.generate(generator);
        result.mArgs = this.mArgs.generate(generator);
        return result;
    }

    protected void populateXML(XML outXML) {
        ExecSubplanStep.addAttributeIfNotNull(outXML, PATH_ATTR, this.getPlanPath());
        outXML.addAttribute(NAME_ATTR, this.mPlanName);
        if (this.mPlanVersion != null && !this.mPlanVersion.equals("")) {
            outXML.addAttribute(VERSION_ATTR, this.mPlanVersion);
        }
        this.mArgs.writeToXML(outXML);
    }

    public String getElementName() {
        return ELEMENT_NAME;
    }

    public boolean equals(ExecStep inStep) {
        if (!(inStep instanceof ExecSubplanStep)) {
            return false;
        }
        ExecSubplanStep theStep = (ExecSubplanStep)inStep;
        if (!this.equals(theStep.getPlanPath(), this.getPlanPath())) {
            return false;
        }
        if (!theStep.getPlanName().equals(this.mPlanName)) {
            return false;
        }
        if (!this.equals(theStep.getPlanVersion(), this.mPlanVersion)) {
            return false;
        }
        return this.mArgs.equals(theStep.mArgs);
    }

    public int getStepType() {
        return 104;
    }

    public void addPlanRefsMS(PlanNameRefAdder adder) throws Exception {
        super.addPlanRefsMS(adder);
        String path = adder.getCaller().getDeclaredPath().getResolvedPath(this.getPlanPath());
        adder.getNameRefSet().addNameRef(this.getPlanName(), path);
    }

    public ExecStep updatePlanRefsMS(PlanNameRefUpdater updater) throws Exception {
        ExecSubplanStep result = (ExecSubplanStep)super.updatePlanRefsMS(updater);
        Caller caller = updater.getCaller();
        SummaryExecutionPlan ep = updater.getPlan();
        String newName = updater.getNewName();
        SummaryFolder newPath = updater.getNewPath();
        String resPath = caller.getDeclaredPath().getResolvedPath(result.getPlanPath());
        if (!this.isRefTo(ep, resPath)) {
            if (newPath != null && this.usesRelativePlanPath() && ExecSubplanStep.samePlan(ep, caller)) {
                result.setPlanPath(newPath.findRelativePath(resPath));
            }
            return result;
        }
        if (newName != null) {
            result.setPlanName(newName);
        }
        if (newPath == null) {
            return result;
        }
        String newRefPath = newPath.getFullPathString();
        if (this.usesRelativePlanPath()) {
            newRefPath = ExecSubplanStep.samePlan(ep, caller) ? null : caller.getDeclaredPath().findRelativePath(newPath.getFullPathString());
        }
        result.setPlanPath(newRefPath);
        return result;
    }

    private boolean usesRelativePlanPath() {
        return this.getPlanPath() == null || !this.getPlanPath().startsWith("/");
    }

    private boolean isRefTo(SummaryExecutionPlan plan, String resolvedPath) {
        return plan.getName().equals(this.getPlanName()) && plan.getPath().getFullPathString().equals(resolvedPath);
    }

    private static boolean samePlan(SummaryExecutionPlan plan, Caller caller) {
        return plan.getName().equals(caller.getDeclaredName()) && plan.getPath().equals(caller.getDeclaredPath());
    }

    void accept(PlanDBVisitor v) throws Exception {
        super.accept(v);
        v.visit(this.mArgs);
    }

    ExecStep accept(PlanDBTransformer t) throws Exception {
        ExecSubplanStep result = (ExecSubplanStep)super.accept(t);
        result.mArgs = (ArgList)t.transform(this.mArgs);
        return result;
    }

    void validateNamespace(PlanDBPluginNSValidator v) throws Exception {
        super.validateNamespace(v);
        SummaryFolder f = v.getCaller().getDeclaredPath().getByResolvedPathQuery(this.getPlanPath()).selectSummaryView();
        SummaryExecutionPlan plan = SingleExecutionPlanQuery.byName(f.getID(), this.getPlanName(), this.getPlanVersion()).selectSummaryView();
        v.getPlugin().validateNamespace(plan.getPluginID(), plan.getFullName(), "executionPlan");
    }
}

