/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.plandb;

import com.raplix.rolloutexpress.config.ConfigGenException;
import com.raplix.rolloutexpress.config.ConfigGenerator;
import com.raplix.rolloutexpress.executor.UnrecognizedStepException;
import com.raplix.rolloutexpress.executor.task.DeploySystemServicesStep;
import com.raplix.rolloutexpress.executor.task.DynamicContainerStep;
import com.raplix.rolloutexpress.executor.task.RemoveSnapshotStep;
import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.systemmodel.SystemModelParseException;
import com.raplix.rolloutexpress.systemmodel.XMLUtil;
import com.raplix.rolloutexpress.systemmodel.plandb.AssignStep;
import com.raplix.rolloutexpress.systemmodel.plandb.CallStep;
import com.raplix.rolloutexpress.systemmodel.plandb.Caller;
import com.raplix.rolloutexpress.systemmodel.plandb.CaptureFileStep;
import com.raplix.rolloutexpress.systemmodel.plandb.CaptureResourceStep;
import com.raplix.rolloutexpress.systemmodel.plandb.CaptureSnapshotStep;
import com.raplix.rolloutexpress.systemmodel.plandb.CheckDependencyStep;
import com.raplix.rolloutexpress.systemmodel.plandb.CheckpointStep;
import com.raplix.rolloutexpress.systemmodel.plandb.CreateDependencyStep;
import com.raplix.rolloutexpress.systemmodel.plandb.CreateSnapshotStep;
import com.raplix.rolloutexpress.systemmodel.plandb.DeployResourceStep;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecJavaStep;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecNativeStep;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecSubplanStep;
import com.raplix.rolloutexpress.systemmodel.plandb.IfStep;
import com.raplix.rolloutexpress.systemmodel.plandb.InlineSubplanStep;
import com.raplix.rolloutexpress.systemmodel.plandb.InstallStep;
import com.raplix.rolloutexpress.systemmodel.plandb.PauseStep;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBException;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBPluginNSValidator;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBTransformer;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBVisitor;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanNameRefAdder;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanNameRefUpdater;
import com.raplix.rolloutexpress.systemmodel.plandb.ProcessTestStep;
import com.raplix.rolloutexpress.systemmodel.plandb.RaiseStep;
import com.raplix.rolloutexpress.systemmodel.plandb.RebootStep;
import com.raplix.rolloutexpress.systemmodel.plandb.RetargetStep;
import com.raplix.rolloutexpress.systemmodel.plandb.ReturnStep;
import com.raplix.rolloutexpress.systemmodel.plandb.SendCustomEventStep;
import com.raplix.rolloutexpress.systemmodel.plandb.TransformStep;
import com.raplix.rolloutexpress.systemmodel.plandb.TryStep;
import com.raplix.rolloutexpress.systemmodel.plandb.URLTestStep;
import com.raplix.rolloutexpress.systemmodel.plandb.UndeployResourceStep;
import com.raplix.rolloutexpress.systemmodel.plandb.UninstallStep;
import com.raplix.util.logger.Logger;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import org.apache.ecs.xml.XML;
import org.w3c.dom.Element;

public abstract class ExecStep
extends XMLUtil
implements RPCSerializable,
Cloneable {
    public static final int THIS_STEP_DOES_NOT_EXIST = -1;
    static final int CHECKPOINT_STEP = 101;
    public static final int CALL_STEP = 102;
    public static final int EXEC_NATIVE_STEP = 103;
    public static final int EXEC_SUBPLAN_STEP = 104;
    public static final int INSTALL_STEP = 105;
    public static final int PROCESS_TEST_STEP = 106;
    public static final int URL_TEST_STEP = 107;
    public static final int SEND_CUSTOM_EVENT_STEP = 108;
    public static final int UNINSTALL_STEP = 109;
    public static final int UNDEPLOY_RESOURCE_STEP = 110;
    public static final int DEPLOY_RESOURCE_STEP = 111;
    public static final int CREATE_DEPENDENCY_STEP = 113;
    public static final int CHECK_DEPENDENCY_STEP = 114;
    public static final int PAUSE_STEP = 115;
    public static final int CREATE_SNAPSHOT_STEP = 116;
    public static final int INLINE_SUBPLAN_STEP = 117;
    public static final int CAPTURE_FILE_STEP = 118;
    public static final int CAPTURE_RESOURCE_STEP = 119;
    public static final int TRANSFORM_STEP = 121;
    public static final int CAPTURE_SNAPSHOT_STEP = 122;
    public static final int EXEC_JAVA_STEP = 123;
    public static final int RAISE_STEP = 124;
    public static final int TRY_STEP = 125;
    public static final int REBOOT_STEP = 126;
    public static final int IF_STEP = 127;
    public static final int RETARGET_STEP = 128;
    public static final int CHECK_HOST_CONNECTIVITY_STEP = 130;
    public static final int CHECK_HOST_PERMISSIONS_STEP = 131;
    public static final int LOCK_HOST_STEP = 132;
    public static final int UNLOCK_HOST_STEP = 133;
    public static final int DEPLOY_SYSTEM_SERVICES_STEP = 134;
    public static final int ACQUIRE_HOST_STEP = 135;
    public static final int DYNAMIC_CONTAINER_STEP = 136;
    public static final int REMOVE_SNAPSHOT_STEP = 137;
    public static final int RETURN_STEP = 138;
    public static final int ASSIGN_STEP = 139;
    public static final String CHECK_HOST_CONNECTIVITY_ELEMENT_NAME = "CheckHostConnectivity";
    public static final String CHECK_HOST_PERMISSIONS_ELEMENT_NAME = "CheckHostPermissions";
    public static final String LOCK_HOST_ELEMENT_NAME = "LockHost";
    public static final String UNLOCK_HOST_ELEMENT_NAME = "UnlockHost";
    public static final String ACQUIRE_HOST_ELEMENT_NAME = "AcquireHost";
    public static final HashSet DEFAULT_BLOCK_IGNORES = new HashSet();
    private int mStepMap = -1;

    public ExecStep() {
    }

    public ExecStep(Element inElement) {
    }

    public final String toString() {
        XML theXML = new XML(this.getElementName());
        this.populateXML(theXML);
        return theXML.toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !(other instanceof ExecStep)) {
            return false;
        }
        return this.equals((ExecStep)other);
    }

    protected boolean equals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    public final void writeToXML(XML outXML) {
        XML thisElement = new XML(this.getElementName());
        thisElement.setPrettyPrint(true);
        this.populateXML(thisElement);
        outXML.addElement((org.apache.ecs.Element)thisElement);
    }

    protected abstract void populateXML(XML var1);

    public abstract String getElementName();

    public abstract boolean equals(ExecStep var1);

    public abstract int getStepType();

    public static ExecStep readFromXML(Element stepElement) throws SystemModelParseException {
        String stepType = stepElement.getNodeName();
        if (stepType.equalsIgnoreCase("checkpoint")) {
            return new CheckpointStep(stepElement);
        }
        if (stepType.equalsIgnoreCase("call")) {
            return new CallStep(stepElement);
        }
        if (stepType.equalsIgnoreCase("execNative")) {
            return new ExecNativeStep(stepElement);
        }
        if (stepType.equalsIgnoreCase("execJava")) {
            return new ExecJavaStep(stepElement);
        }
        if (stepType.equalsIgnoreCase("install")) {
            return new InstallStep(stepElement);
        }
        if (stepType.equalsIgnoreCase("processTest")) {
            return new ProcessTestStep(stepElement);
        }
        if (stepType.equalsIgnoreCase("sendCustomEvent")) {
            return new SendCustomEventStep(stepElement);
        }
        if (stepType.equalsIgnoreCase("raise")) {
            return new RaiseStep(stepElement);
        }
        if (stepType.equalsIgnoreCase("retarget")) {
            return new RetargetStep(stepElement);
        }
        if (stepType.equalsIgnoreCase("try")) {
            return new TryStep(stepElement);
        }
        if (stepType.equalsIgnoreCase("if")) {
            return new IfStep(stepElement);
        }
        if (stepType.equalsIgnoreCase("reboot")) {
            return new RebootStep(stepElement);
        }
        if (stepType.equalsIgnoreCase("uninstall")) {
            return new UninstallStep(stepElement);
        }
        if (stepType.equalsIgnoreCase("urlTest")) {
            return new URLTestStep(stepElement);
        }
        if (stepType.equalsIgnoreCase("execSubplan")) {
            return new ExecSubplanStep(stepElement);
        }
        if (stepType.equalsIgnoreCase("deployResource")) {
            return new DeployResourceStep(stepElement);
        }
        if (stepType.equalsIgnoreCase("undeployResource")) {
            return new UndeployResourceStep(stepElement);
        }
        if (stepType.equalsIgnoreCase("checkDependency")) {
            return new CheckDependencyStep(stepElement);
        }
        if (stepType.equalsIgnoreCase("createDependency")) {
            return new CreateDependencyStep(stepElement);
        }
        if (stepType.equalsIgnoreCase("pause")) {
            return new PauseStep(stepElement);
        }
        if (stepType.equalsIgnoreCase("createSnapshot")) {
            return new CreateSnapshotStep(stepElement);
        }
        if (stepType.equalsIgnoreCase("inlineSubplan")) {
            return new InlineSubplanStep(stepElement);
        }
        if (stepType.equalsIgnoreCase("addFile")) {
            return new CaptureFileStep(stepElement);
        }
        if (stepType.equalsIgnoreCase("addResource")) {
            return new CaptureResourceStep(stepElement);
        }
        if (stepType.equalsIgnoreCase("addSnapshot")) {
            return new CaptureSnapshotStep(stepElement);
        }
        if (stepType.equalsIgnoreCase("transform")) {
            return new TransformStep(stepElement);
        }
        if (stepType.equalsIgnoreCase("deploySystemServices")) {
            return new DeploySystemServicesStep(stepElement);
        }
        if (stepType.equalsIgnoreCase("removeSnapshot")) {
            return new RemoveSnapshotStep(stepElement);
        }
        if (stepType.equalsIgnoreCase("return")) {
            return new ReturnStep(stepElement);
        }
        if (stepType.equalsIgnoreCase("assign")) {
            return new AssignStep(stepElement);
        }
        if (Logger.isErrorEnabled("com.raplix.rolloutexpress.systemmodel")) {
            Logger.error("ExecStep doesn't know how to parse this flavor of execstep: " + stepType, "com.raplix.rolloutexpress.systemmodel");
        }
        return null;
    }

    public static String getStepTypeStringRepresentation(int inType) throws UnrecognizedStepException {
        switch (inType) {
            case 101: {
                return "checkpoint";
            }
            case 111: {
                return "deployResource";
            }
            case 110: {
                return "undeployResource";
            }
            case 102: {
                return "call";
            }
            case 103: {
                return "execNative";
            }
            case 123: {
                return "execJava";
            }
            case 104: {
                return "execSubplan";
            }
            case 105: {
                return "install";
            }
            case 106: {
                return "processTest";
            }
            case 108: {
                return "sendCustomEvent";
            }
            case 124: {
                return "raise";
            }
            case 128: {
                return "retarget";
            }
            case 125: {
                return "try";
            }
            case 127: {
                return "if";
            }
            case 126: {
                return "reboot";
            }
            case 109: {
                return "uninstall";
            }
            case 107: {
                return "urlTest";
            }
            case 114: {
                return "checkDependency";
            }
            case 113: {
                return "createDependency";
            }
            case 115: {
                return "pause";
            }
            case 116: {
                return "createSnapshot";
            }
            case 117: {
                return "inlineSubplan";
            }
            case 118: {
                return "addFile";
            }
            case 122: {
                return "addSnapshot";
            }
            case 119: {
                return "addResource";
            }
            case 121: {
                return "transform";
            }
            case 138: {
                return "return";
            }
            case 139: {
                return "assign";
            }
            case 130: {
                return CHECK_HOST_CONNECTIVITY_ELEMENT_NAME;
            }
            case 131: {
                return CHECK_HOST_PERMISSIONS_ELEMENT_NAME;
            }
            case 132: {
                return LOCK_HOST_ELEMENT_NAME;
            }
            case 133: {
                return UNLOCK_HOST_ELEMENT_NAME;
            }
            case 134: {
                return "deploySystemServices";
            }
            case 135: {
                return ACQUIRE_HOST_ELEMENT_NAME;
            }
            case 136: {
                return "dynamicContainer";
            }
            case 137: {
                return "removeSnapshot";
            }
        }
        throw new UnrecognizedStepException(inType);
    }

    public static Class getStepClassForType(int inType) {
        switch (inType) {
            case 101: {
                return CheckpointStep.class;
            }
            case 111: {
                return DeployResourceStep.class;
            }
            case 110: {
                return UndeployResourceStep.class;
            }
            case 102: {
                return CallStep.class;
            }
            case 103: {
                return ExecNativeStep.class;
            }
            case 123: {
                return ExecJavaStep.class;
            }
            case 104: {
                return ExecSubplanStep.class;
            }
            case 105: {
                return InstallStep.class;
            }
            case 106: {
                return ProcessTestStep.class;
            }
            case 124: {
                return RaiseStep.class;
            }
            case 128: {
                return RetargetStep.class;
            }
            case 125: {
                return TryStep.class;
            }
            case 127: {
                return IfStep.class;
            }
            case 126: {
                return RebootStep.class;
            }
            case 109: {
                return UninstallStep.class;
            }
            case 107: {
                return URLTestStep.class;
            }
            case 113: {
                return CreateDependencyStep.class;
            }
            case 114: {
                return CheckDependencyStep.class;
            }
            case 115: {
                return PauseStep.class;
            }
            case 116: {
                return CreateSnapshotStep.class;
            }
            case 117: {
                return InlineSubplanStep.class;
            }
            case 118: {
                return CaptureFileStep.class;
            }
            case 122: {
                return CaptureSnapshotStep.class;
            }
            case 119: {
                return CaptureResourceStep.class;
            }
            case 121: {
                return TransformStep.class;
            }
            case 134: {
                return DeploySystemServicesStep.class;
            }
            case 136: {
                return DynamicContainerStep.class;
            }
            case 137: {
                return RemoveSnapshotStep.class;
            }
            case 138: {
                return ReturnStep.class;
            }
            case 139: {
                return AssignStep.class;
            }
        }
        return null;
    }

    public ExecStep generate(ConfigGenerator generator) throws ConfigGenException {
        return (ExecStep)this.clone();
    }

    public static void parseExecSteps(Element inElement, Vector outContainer) throws SystemModelParseException {
        ExecStep.parseExecSteps(inElement, outContainer, DEFAULT_BLOCK_IGNORES);
    }

    public static void parseExecSteps(Element inElement, Vector outContainer, Set ignoreList) throws SystemModelParseException {
        Element[] children = ExecStep.getChildren(inElement);
        for (int i = 0; i < children.length; ++i) {
            Element child = children[i];
            String stepName = child.getNodeName();
            if (ignoreList.contains(stepName)) continue;
            ExecStep theStep = ExecStep.readFromXML(child);
            outContainer.addElement(theStep);
        }
    }

    public static ExecStep[] parseStepBlock(Element elem, String blockName) throws SystemModelParseException {
        Element[] blocks = ExecStep.getChildren(elem, blockName);
        if (blocks.length == 0) {
            return null;
        }
        Vector steps = new Vector();
        ExecStep.parseExecSteps(blocks[0], steps);
        return steps.toArray(new ExecStep[steps.size()]);
    }

    public static void writeStepBlock(XML outXML, String blockName, ExecStep[] steps) {
        if (steps == null) {
            return;
        }
        XML block = new XML(blockName);
        block.setPrettyPrint(true);
        ExecStep.writeSteps(block, steps);
        outXML.addElement((org.apache.ecs.Element)block);
    }

    public static void writeSteps(XML outXML, ExecStep[] steps) {
        if (steps == null) {
            return;
        }
        for (int i = 0; i < steps.length; ++i) {
            steps[i].writeToXML(outXML);
        }
    }

    public void validate(Caller container) throws PlanDBException {
    }

    public static void validateSteps(Vector steps, Caller container) throws PlanDBException {
        int numSteps = steps.size();
        for (int i = 0; i < numSteps; ++i) {
            ((ExecStep)steps.get(i)).validate(container);
        }
    }

    public static void validateSteps(ExecStep[] steps, Caller container) throws PlanDBException {
        int numSteps = steps.length;
        for (int i = 0; i < numSteps; ++i) {
            steps[i].validate(container);
        }
    }

    public static Vector deepClone(Vector steps) {
        steps = (Vector)steps.clone();
        int numSteps = steps.size();
        for (int i = 0; i < numSteps; ++i) {
            steps.set(i, ((ExecStep)steps.get(i)).clone());
        }
        return steps;
    }

    public static ExecStep[] deepClone(ExecStep[] steps) {
        steps = (ExecStep[])steps.clone();
        for (int i = 0; i < steps.length; ++i) {
            steps[i] = (ExecStep)steps[i].clone();
        }
        return steps;
    }

    public int getStepMap() {
        return this.mStepMap;
    }

    public void setStepMap(int inStepMap) {
        this.mStepMap = inStepMap;
    }

    protected Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    void accept(PlanDBVisitor v) throws Exception {
    }

    ExecStep accept(PlanDBTransformer t) throws Exception {
        return t.clone(this);
    }

    ExecStep cloneForTransform() {
        return (ExecStep)this.clone();
    }

    void addPlanRefsMS(PlanNameRefAdder adder) throws Exception {
    }

    ExecStep updatePlanRefsMS(PlanNameRefUpdater updater) throws Exception {
        return (ExecStep)this.clone();
    }

    void validateNamespace(PlanDBPluginNSValidator v) throws Exception {
        this.accept(v);
    }

    static {
        DEFAULT_BLOCK_IGNORES.add("paramList");
        DEFAULT_BLOCK_IGNORES.add("varList");
    }
}

