/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.plandb;

import com.raplix.rolloutexpress.config.ConfigGenException;
import com.raplix.rolloutexpress.config.ConfigGenerator;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.systemmodel.SystemModelParseException;
import com.raplix.rolloutexpress.systemmodel.plandb.ComponentStep;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecStep;
import com.raplix.rolloutexpress.systemmodel.plandb.LabeledStep;
import com.raplix.rolloutexpress.systemmodel.plandb.Messages;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBTransformer;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBVisitor;
import com.raplix.rolloutexpress.systemmodel.plandb.SimplePlanStep;
import com.raplix.rolloutexpress.systemmodel.plandb.SnapshotPrepareStep;
import com.raplix.util.Util;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.apache.ecs.xml.XML;
import org.w3c.dom.Element;

public class ExecNativeStep
extends ExecStep
implements Messages,
ComponentStep,
SimplePlanStep,
SnapshotPrepareStep,
LabeledStep {
    public static final String ELEMENT_NAME = "execNative";
    public static final String ATTR_DIR = "dir";
    public static final String ELEM_BACKGROUND = "background";
    public static final String ELEM_OUTPUT_FILE = "outputFile";
    public static final String ELEM_INPUT_FILE = "inputFile";
    public static final String ELEM_INPUT_TEXT = "inputText";
    public static final String ELEM_ERROR_FILE = "errorFile";
    public static final String ATTR_TIMEOUT = "timeout";
    public static final String ATTR_RUN_AS = "userToRunAs";
    public static final String ELEM_ENV = "env";
    public static final String ATTR_VALUE = "value";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_LABEL = "label";
    public static final String ELEM_ASSIGN_OUTPUT = "assignOutput";
    public static final String ELEM_ASSIGN_ERROR = "assignError";
    public static final String ELEM_ASSIGN_STATUS = "assignStatus";
    public static final String ATTR_VARNAME = "varName";
    public static final String ATTR_CMD = "cmd";
    public static final String ELEM_EXEC = "exec";
    public static final String ELEM_SHELL = "shell";
    public static final String ELEM_ARG = "arg";
    public static final String ELEM_SUCCESS_CRITERIA = "successCriteria";
    public static final String ATTR_STATUS = "status";
    public static final String ATTR_OUTPUT_MATCHES = "outputMatches";
    public static final String ATTR_ERROR_MATCHES = "errorMatches";
    public static final String ATTR_INVERSE = "inverse";
    private String mDir = null;
    private String mLabel = null;
    private String mOutputFile = null;
    private String mAssignOutput = null;
    private String mAssignError = null;
    private String mAssignStatus = null;
    private String mErrorFile = null;
    private String mInputFile = null;
    private String mInputText = null;
    private long mTimeout = Long.MIN_VALUE;
    private String mRunAs = null;
    private String[] mArgs = null;
    private Hashtable mEnv = null;
    private String mCommand = null;
    private String mExec = null;
    private String mShell = null;
    private long mStatus = Long.MAX_VALUE;
    private String mOutputMatches = null;
    private String mErrorMatches = null;
    private boolean mInverse = false;
    private boolean mIgnore = false;
    private boolean mBackground = false;
    public static final long TIMEOUT_UNSPECIFIED = Long.MIN_VALUE;
    public static final long STATUS_UNSPECIFIED = Long.MAX_VALUE;

    private ExecNativeStep() {
    }

    public ExecNativeStep(Element nativeElem) throws SystemModelParseException {
        super(nativeElem);
        this.mDir = ExecNativeStep.getAttribute(nativeElem, ATTR_DIR);
        this.mLabel = ExecNativeStep.getAttribute(nativeElem, ATTR_LABEL);
        this.mOutputFile = this.parseFilenameElem(nativeElem, ELEM_OUTPUT_FILE);
        this.mAssignOutput = this.parseAssignElem(nativeElem, ELEM_ASSIGN_OUTPUT);
        this.mAssignError = this.parseAssignElem(nativeElem, ELEM_ASSIGN_ERROR);
        this.mAssignStatus = this.parseAssignElem(nativeElem, ELEM_ASSIGN_STATUS);
        this.mErrorFile = this.parseFilenameElem(nativeElem, ELEM_ERROR_FILE);
        this.mInputFile = this.parseFilenameElem(nativeElem, ELEM_INPUT_FILE);
        Element[] elements = ExecNativeStep.getChildren(nativeElem, ELEM_INPUT_TEXT);
        if (elements.length > 0) {
            this.mInputText = ExecNativeStep.getTextContent(elements[0]);
        }
        this.mBackground = (elements = ExecNativeStep.getChildren(nativeElem, ELEM_BACKGROUND)).length > 0;
        this.mRunAs = ExecNativeStep.getAttribute(nativeElem, ATTR_RUN_AS);
        this.parseEnv(ExecNativeStep.getChildren(nativeElem, ELEM_ENV));
        elements = ExecNativeStep.getChildren(nativeElem, ELEM_EXEC);
        if (elements.length > 0) {
            this.mExec = ExecNativeStep.getAttribute(elements[0], ATTR_CMD);
            this.mArgs = ExecNativeStep.parseArgs(ExecNativeStep.getChildren(elements[0], ELEM_ARG));
        }
        if ((elements = ExecNativeStep.getChildren(nativeElem, ELEM_SHELL)).length > 0) {
            this.mShell = ExecNativeStep.getAttribute(elements[0], ATTR_CMD);
            this.mCommand = ExecNativeStep.getTextContent(elements[0]);
        }
        if ((elements = ExecNativeStep.getChildren(nativeElem, ELEM_SUCCESS_CRITERIA)).length > 0) {
            this.parseSuccessCriteria(elements[0]);
        } else {
            this.mStatus = 0L;
        }
        String str = "";
        try {
            str = ExecNativeStep.getAttribute(nativeElem, ATTR_TIMEOUT);
            if (str != null) {
                this.mTimeout = Long.parseLong(str);
            }
        }
        catch (NumberFormatException nfe) {
            throw new SystemModelParseException(new ROXMessage("pdb.ENATIVE_INVALID_TIMEOUT", str, this.getCommandStringForErrMsg()));
        }
    }

    public String getDir() {
        return this.mDir;
    }

    public String getLabel() {
        return this.mLabel;
    }

    public String getErrorFile() {
        return this.mErrorFile;
    }

    public String getOutputFile() {
        return this.mOutputFile;
    }

    public String getInputFile() {
        return this.mInputFile;
    }

    public String getInputText() {
        return this.mInputText;
    }

    public long getTimeout() {
        return this.mTimeout;
    }

    public String getUserToRunAs() {
        return this.mRunAs;
    }

    public Hashtable getEnv() {
        return this.mEnv == null ? (Hashtable)null : (Hashtable)this.mEnv.clone();
    }

    public String getCommand() {
        return this.mCommand;
    }

    public String getExec() {
        return this.mExec;
    }

    public String getShell() {
        return this.mShell;
    }

    public String[] getArgs() {
        return this.mArgs == null ? null : (String[])this.mArgs.clone();
    }

    public long getStatus() {
        return this.mStatus;
    }

    public String getOutputMatches() {
        return this.mOutputMatches;
    }

    public String getErrorMatches() {
        return this.mErrorMatches;
    }

    public boolean getInverse() {
        return this.mInverse;
    }

    public boolean getIgnore() {
        return this.mIgnore;
    }

    public String getAssignOutput() {
        return this.mAssignOutput;
    }

    public String getAssignError() {
        return this.mAssignError;
    }

    public String getAssignStatus() {
        return this.mAssignStatus;
    }

    public boolean getBackground() {
        return this.mBackground;
    }

    private void setBackground(boolean background) {
        this.mBackground = background;
    }

    protected void populateXML(XML outXML) {
        XML successCriteria;
        outXML.setPrettyPrint(true);
        ExecNativeStep.addAttributeIfNotNull(outXML, ATTR_DIR, this.mDir);
        ExecNativeStep.addAttributeIfNotNull(outXML, ATTR_LABEL, this.mLabel);
        if (this.mTimeout != Long.MIN_VALUE) {
            ExecNativeStep.addAttributeIfNotNull(outXML, ATTR_TIMEOUT, String.valueOf(this.mTimeout));
        }
        ExecNativeStep.addAttributeIfNotNull(outXML, ATTR_RUN_AS, this.mRunAs);
        if (this.mEnv != null && !this.mEnv.isEmpty()) {
            Iterator entries = this.mEnv.entrySet().iterator();
            while (entries.hasNext()) {
                XML env = new XML(ELEM_ENV);
                env.setPrettyPrint(true);
                Map.Entry entry = entries.next();
                ExecNativeStep.addAttributeIfNotNull(env, ATTR_NAME, (String)entry.getKey());
                ExecNativeStep.addAttributeIfNotNull(env, ATTR_VALUE, (String)entry.getValue());
                outXML.addElement((org.apache.ecs.Element)env);
            }
        }
        if (this.mBackground) {
            XML bg = new XML(ELEM_BACKGROUND);
            bg.setPrettyPrint(true);
            outXML.addElement((org.apache.ecs.Element)bg);
        }
        this.writeFilenameElem(outXML, ELEM_OUTPUT_FILE, this.mOutputFile);
        this.writeFilenameElem(outXML, ELEM_ERROR_FILE, this.mErrorFile);
        if (this.mAssignOutput != null) {
            XML assignOutput = new XML(ELEM_ASSIGN_OUTPUT);
            assignOutput.setPrettyPrint(true);
            ExecNativeStep.addAttributeIfNotNull(assignOutput, ATTR_VARNAME, this.mAssignOutput);
            outXML.addElement((org.apache.ecs.Element)assignOutput);
        }
        if (this.mAssignError != null) {
            XML assignError = new XML(ELEM_ASSIGN_ERROR);
            assignError.setPrettyPrint(true);
            ExecNativeStep.addAttributeIfNotNull(assignError, ATTR_VARNAME, this.mAssignError);
            outXML.addElement((org.apache.ecs.Element)assignError);
        }
        if (this.mAssignStatus != null) {
            XML assignStatus = new XML(ELEM_ASSIGN_STATUS);
            assignStatus.setPrettyPrint(true);
            ExecNativeStep.addAttributeIfNotNull(assignStatus, ATTR_VARNAME, this.mAssignStatus);
            outXML.addElement((org.apache.ecs.Element)assignStatus);
        }
        if (this.mInputText != null && this.mInputText.trim().length() > 0) {
            XML iText = new XML(ELEM_INPUT_TEXT);
            iText.setPrettyPrint(true);
            iText.setTagText(ExecNativeStep.encloseInCDATA(this.mInputText));
            outXML.addElement((org.apache.ecs.Element)iText);
        }
        this.writeFilenameElem(outXML, ELEM_INPUT_FILE, this.mInputFile);
        if (this.mExec != null) {
            XML exec = new XML(ELEM_EXEC);
            exec.setPrettyPrint(true);
            ExecNativeStep.addAttributeIfNotNull(exec, ATTR_CMD, this.mExec);
            if (this.mArgs != null && this.mArgs.length > 0) {
                for (int i = 0; i < this.mArgs.length; ++i) {
                    XML arg = new XML(ELEM_ARG);
                    arg.setPrettyPrint(true);
                    ExecNativeStep.addAttributeIfNotNull(arg, ATTR_VALUE, this.mArgs[i]);
                    exec.addElement((org.apache.ecs.Element)arg);
                }
            }
            outXML.addElement((org.apache.ecs.Element)exec);
        }
        if (this.mShell != null) {
            XML shell = new XML(ELEM_SHELL);
            shell.setPrettyPrint(true);
            ExecNativeStep.addAttributeIfNotNull(shell, ATTR_CMD, this.mShell);
            if (this.mCommand != null) {
                shell.setTagText(ExecNativeStep.encloseInCDATA(this.mCommand));
            }
            outXML.addElement((org.apache.ecs.Element)shell);
        }
        if (this.mIgnore) {
            successCriteria = new XML(ELEM_SUCCESS_CRITERIA);
            successCriteria.setPrettyPrint(true);
            outXML.addElement((org.apache.ecs.Element)successCriteria);
        } else if (this.mStatus != 0L || this.mOutputMatches != null || this.mErrorMatches != null || this.mInverse) {
            successCriteria = new XML(ELEM_SUCCESS_CRITERIA);
            successCriteria.setPrettyPrint(true);
            if (this.mStatus != Long.MAX_VALUE) {
                ExecNativeStep.addAttributeIfNotNull(successCriteria, ATTR_STATUS, String.valueOf(this.mStatus));
            }
            if (this.mOutputMatches != null) {
                ExecNativeStep.addAttributeIfNotNull(successCriteria, ATTR_OUTPUT_MATCHES, this.mOutputMatches);
            }
            if (this.mErrorMatches != null) {
                ExecNativeStep.addAttributeIfNotNull(successCriteria, ATTR_ERROR_MATCHES, this.mErrorMatches);
            }
            if (this.mInverse) {
                ExecNativeStep.addAttributeIfNotNull(successCriteria, ATTR_INVERSE, String.valueOf(this.mInverse));
            }
            outXML.addElement((org.apache.ecs.Element)successCriteria);
        }
    }

    private void writeFilenameElem(XML outXML, String elemName, String filename) {
        if (filename != null) {
            XML iFile = new XML(elemName);
            iFile.setPrettyPrint(true);
            ExecNativeStep.addAttributeIfNotNull(iFile, ATTR_NAME, filename);
            outXML.addElement((org.apache.ecs.Element)iFile);
        }
    }

    public String getElementName() {
        return ELEMENT_NAME;
    }

    public boolean equals(ExecStep inStep) {
        if (inStep == null || !(inStep instanceof ExecNativeStep)) {
            return false;
        }
        ExecNativeStep theStep = (ExecNativeStep)inStep;
        return Util.isEqual(this.mDir, theStep.mDir) && Util.isEqual(this.mLabel, theStep.mLabel) && Util.isEqual(this.mOutputFile, theStep.mOutputFile) && Util.isEqual(this.mAssignOutput, theStep.mAssignOutput) && Util.isEqual(this.mAssignError, theStep.mAssignError) && Util.isEqual(this.mAssignStatus, theStep.mAssignStatus) && Util.isEqual(this.mErrorFile, theStep.mErrorFile) && Util.isEqual(this.mInputFile, theStep.mInputFile) && Util.isEqual(this.mInputText, theStep.mInputText) && this.mTimeout == theStep.mTimeout && this.mBackground == theStep.mBackground && Util.isEqual(this.mRunAs, theStep.mRunAs) && Util.isEqual(this.mEnv, theStep.mEnv) && Util.isEqual(this.mCommand, theStep.mCommand) && Util.isEqual(this.mExec, theStep.mExec) && Util.isEqual(this.mShell, theStep.mShell) && Arrays.equals(this.mArgs, theStep.mArgs) && this.mStatus == theStep.mStatus && Util.isEqual(this.mOutputMatches, theStep.mOutputMatches) && Util.isEqual(this.mErrorMatches, theStep.mErrorMatches) && this.mInverse == theStep.mInverse && this.mIgnore == theStep.mIgnore;
    }

    public int getStepType() {
        return 103;
    }

    public ExecStep generate(ConfigGenerator generator) throws ConfigGenException {
        ExecNativeStep copy = (ExecNativeStep)super.generate(generator);
        copy.mDir = this.generateString(generator, this.mDir);
        copy.mLabel = this.generateString(generator, this.mLabel);
        copy.mOutputFile = this.generateString(generator, this.mOutputFile);
        copy.mErrorFile = this.generateString(generator, this.mErrorFile);
        copy.mInputFile = this.generateString(generator, this.mInputFile);
        copy.mInputText = this.generateString(generator, this.mInputText);
        copy.mRunAs = this.generateString(generator, this.mRunAs);
        copy.mEnv = ExecNativeStep.generateHashtable(generator, this.mEnv);
        copy.mCommand = this.generateString(generator, this.mCommand);
        copy.mExec = this.generateString(generator, this.mExec);
        copy.mShell = this.generateString(generator, this.mShell);
        copy.mArgs = this.generateStringArray(generator, this.mArgs);
        copy.mOutputMatches = this.generateString(generator, this.mOutputMatches);
        copy.mErrorMatches = this.generateString(generator, this.mErrorMatches);
        return copy;
    }

    public String getCommandStringForErrMsg() {
        String prefix = "";
        if (this.mBackground) {
            prefix = "bg ";
        }
        if (this.mExec != null) {
            return prefix + this.mExec + (this.mArgs == null || this.mArgs.length < 1 ? "" : " " + Util.getStringFromArray(this.mArgs, " "));
        }
        return prefix + this.mShell + " " + this.mCommand;
    }

    private String generateString(ConfigGenerator generator, String value) throws ConfigGenException {
        return value == null ? null : generator.generate(value);
    }

    private String[] generateStringArray(ConfigGenerator generator, String[] value) throws ConfigGenException {
        if (value != null) {
            String[] returnValue = new String[value.length];
            for (int i = 0; i < value.length; ++i) {
                returnValue[i] = this.generateString(generator, value[i]);
            }
            return returnValue;
        }
        return null;
    }

    private static Hashtable generateHashtable(ConfigGenerator generator, Hashtable vars) throws ConfigGenException {
        if (vars == null || vars.isEmpty()) {
            return vars;
        }
        Hashtable<String, String> table = new Hashtable<String, String>(vars.size());
        Iterator entries = vars.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            table.put(generator.generate((String)entry.getKey()), generator.generate((String)entry.getValue()));
        }
        return table;
    }

    private void parseSuccessCriteria(Element successCriteria) throws SystemModelParseException {
        String str = "";
        try {
            str = ExecNativeStep.getAttribute(successCriteria, ATTR_STATUS);
            this.mStatus = str != null ? (long)Integer.parseInt(str) : Long.MAX_VALUE;
        }
        catch (NumberFormatException nfe) {
            throw new SystemModelParseException(new ROXMessage("pdb.ENATIVE_INVALID_STATUS", str, this.getCommandStringForErrMsg()));
        }
        this.mOutputMatches = ExecNativeStep.getAttribute(successCriteria, ATTR_OUTPUT_MATCHES);
        this.mErrorMatches = ExecNativeStep.getAttribute(successCriteria, ATTR_ERROR_MATCHES);
        Boolean inverse = ExecNativeStep.getBooleanAttribute(successCriteria, ATTR_INVERSE);
        boolean bl = this.mInverse = inverse == null ? false : inverse;
        if (this.mOutputMatches == null && this.mErrorMatches == null && this.mStatus == Long.MAX_VALUE) {
            this.mInverse = false;
        }
        this.mIgnore = this.mStatus == Long.MAX_VALUE && this.mOutputMatches == null && this.mErrorMatches == null;
    }

    private static String[] parseArgs(Element[] elems) {
        if (elems != null && elems.length > 0) {
            String[] args = new String[elems.length];
            for (int i = 0; i < elems.length; ++i) {
                args[i] = ExecNativeStep.getAttribute(elems[i], ATTR_VALUE);
                if (args[i] != null) continue;
                args[i] = "";
            }
            return args;
        }
        return null;
    }

    private void parseEnv(Element[] elems) {
        if (elems != null && elems.length > 0) {
            this.mEnv = new Hashtable(elems.length);
            for (int i = 0; i < elems.length; ++i) {
                String value = ExecNativeStep.getAttribute(elems[i], ATTR_VALUE);
                this.mEnv.put(ExecNativeStep.getAttribute(elems[i], ATTR_NAME), value == null ? "" : value);
            }
        }
    }

    private String parseFilenameElem(Element parent, String childName) {
        Element[] elements = ExecNativeStep.getChildren(parent, childName);
        if (elements.length == 0) {
            return null;
        }
        return ExecNativeStep.getAttribute(elements[0], ATTR_NAME);
    }

    private String parseAssignElem(Element parent, String childName) {
        Element[] elements = ExecNativeStep.getChildren(parent, childName);
        if (elements.length == 0) {
            return null;
        }
        return ExecNativeStep.getAttribute(elements[0], ATTR_VARNAME);
    }

    void accept(PlanDBVisitor v) throws Exception {
        super.accept(v);
        v.visitToken(this.getDir());
        v.visitToken(this.getLabel());
        v.visitToken(this.getOutputFile());
        v.visitToken(this.getErrorFile());
        v.visitMutableVar(this.getAssignOutput());
        v.visitMutableVar(this.getAssignError());
        v.visitMutableVar(this.getAssignStatus());
        v.visitToken(this.getInputFile());
        v.visitToken(this.getInputText());
        v.visitToken(this.getUserToRunAs());
        v.visitToken(this.getCommand());
        v.visitToken(this.getExec());
        v.visitToken(this.getShell());
        v.visitToken(this.getOutputMatches());
        v.visitToken(this.getErrorMatches());
        if (this.mArgs != null) {
            for (int i = 0; i < this.mArgs.length; ++i) {
                v.visitToken(this.mArgs[i]);
            }
        }
        if (this.mEnv != null) {
            Iterator entries = this.mEnv.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                v.visitToken((String)entry.getKey());
                v.visitToken((String)entry.getValue());
            }
        }
    }

    ExecStep accept(PlanDBTransformer t) throws Exception {
        ExecNativeStep result = (ExecNativeStep)super.accept(t);
        result.mDir = t.transformToken(this.getDir());
        result.mOutputFile = t.transformToken(this.getOutputFile());
        result.mErrorFile = t.transformToken(this.getErrorFile());
        result.mInputFile = t.transformToken(this.getInputFile());
        result.mInputText = t.transformToken(this.getInputText());
        result.mRunAs = t.transformToken(this.getUserToRunAs());
        result.mCommand = t.transformToken(this.getCommand());
        result.mExec = t.transformToken(this.getExec());
        result.mShell = t.transformToken(this.getShell());
        result.mOutputMatches = t.transformToken(this.getOutputMatches());
        result.mErrorMatches = t.transformToken(this.getErrorMatches());
        if (this.mArgs != null) {
            String[] resultArgs = new String[this.mArgs.length];
            for (int i = 0; i < this.mArgs.length; ++i) {
                resultArgs[i] = t.transformToken(this.mArgs[i]);
            }
            result.mArgs = resultArgs;
        }
        if (this.mEnv != null) {
            Hashtable<String, String> resultEnv = new Hashtable<String, String>(this.mEnv.size());
            Iterator entries = this.mEnv.entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                resultEnv.put(t.transformToken((String)entry.getKey()), t.transformToken((String)entry.getValue()));
            }
            result.mEnv = resultEnv;
        }
        return result;
    }

    public ExecNativeStep(String exec, String[] args) {
        this(null, null, null, null, null, null, null, null, exec, null, null, args, null, null, null, null, Boolean.TRUE, null, null, null, null, null);
    }

    public ExecNativeStep(String exec, String[] args, String outputMatches) {
        this(null, null, null, null, null, null, null, null, exec, null, null, args, null, outputMatches, null, null, null, null, null, null, null, null);
    }

    public ExecNativeStep(String dir, String outputFile, String errorFile, String inputFile, String inputText, Long timeout, String runAs, Hashtable env, String exec, String shell, String command, String[] args, Integer status, String outputMatches, String errorMatches, Boolean inverse, Boolean ignore, Boolean background) {
        this(dir, outputFile, errorFile, inputFile, inputText, timeout, runAs, env, exec, shell, command, args, status, outputMatches, errorMatches, inverse, ignore, background, null, null, null, null);
    }

    public ExecNativeStep(String dir, String outputFile, String errorFile, String inputFile, String inputText, Long timeout, String runAs, Hashtable env, String exec, String shell, String command, String[] args, Integer status, String outputMatches, String errorMatches, Boolean inverse, Boolean ignore, Boolean background, String label, String assignOutput, String assignError, String assignStatus) {
        this.mDir = dir;
        this.mLabel = label;
        this.mOutputFile = outputFile;
        this.mAssignOutput = assignOutput;
        this.mAssignError = assignError;
        this.mAssignStatus = assignStatus;
        this.mErrorFile = errorFile;
        this.mInputFile = inputFile;
        this.mInputText = inputText;
        this.mTimeout = timeout == null ? Long.MIN_VALUE : timeout;
        this.mRunAs = runAs;
        this.mEnv = env;
        this.mExec = exec;
        this.mShell = shell;
        this.mCommand = command;
        this.mArgs = args;
        boolean bl = this.mIgnore = ignore == null ? false : ignore;
        if (this.mIgnore) {
            this.mStatus = Long.MAX_VALUE;
            this.mOutputMatches = null;
            this.mErrorMatches = null;
            this.mInverse = false;
        } else {
            this.mStatus = status == null ? Long.MAX_VALUE : (long)status.intValue();
            this.mOutputMatches = outputMatches;
            this.mErrorMatches = errorMatches;
            if (this.mStatus == Long.MAX_VALUE && this.mOutputMatches == null && this.mErrorMatches == null) {
                this.mStatus = 0L;
                this.mInverse = false;
            } else {
                boolean bl2 = this.mInverse = inverse == null ? false : inverse;
            }
        }
        if (background != null) {
            this.mBackground = background;
        }
    }
}

