/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.plandb;

import com.raplix.rolloutexpress.config.ConfigGenException;
import com.raplix.rolloutexpress.config.ConfigGenerator;
import com.raplix.rolloutexpress.config.VariableSettingsSource;
import com.raplix.rolloutexpress.systemmodel.SystemModelParseException;
import com.raplix.rolloutexpress.systemmodel.plandb.ArgList;
import com.raplix.rolloutexpress.systemmodel.plandb.ComponentStep;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecStep;
import com.raplix.rolloutexpress.systemmodel.plandb.LabeledStep;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBTransformer;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBVisitor;
import com.raplix.rolloutexpress.systemmodel.plandb.SimplePlanStep;
import com.raplix.util.ObjectUtil;
import org.apache.ecs.xml.XML;
import org.w3c.dom.Element;

public class ExecJavaStep
extends ExecStep
implements SimplePlanStep,
ComponentStep,
LabeledStep {
    public static final String ELEMENT_NAME = "execJava";
    private static final String ATTR_CLASS_NAME = "className";
    private static final String ATTR_CLASS_PATH = "classPath";
    private static final String ATTR_TIMEOUT = "timeout";
    private static final String ATTR_LABEL = "label";
    private static final String ELEM_ASSIGN_OUTPUT = "assignOutput";
    private static final String ELEM_ASSIGN_ERROR = "assignError";
    private static final String ATTR_VARNAME = "varName";
    public static final long TIMEOUT_UNSPECIFIED = Long.MIN_VALUE;
    private String mClassName;
    private String mClassPath;
    private String mLabel;
    private String mAssignOutput;
    private String mAssignError;
    private long mTimeout = Long.MIN_VALUE;
    private ArgList mArgs;

    private ExecJavaStep() {
    }

    public ExecJavaStep(Element execJavaElement) throws SystemModelParseException {
        super(execJavaElement);
        this.setClassName(ExecJavaStep.getAttribute(execJavaElement, ATTR_CLASS_NAME));
        this.setClassPath(ExecJavaStep.getAttribute(execJavaElement, ATTR_CLASS_PATH));
        this.setTimeout(ExecJavaStep.getAttribute(execJavaElement, ATTR_TIMEOUT));
        this.setArgs(new ArgList(execJavaElement));
        this.setLabel(ExecJavaStep.getAttribute(execJavaElement, ATTR_LABEL));
        Element[] elements = ExecJavaStep.getChildren(execJavaElement, ELEM_ASSIGN_OUTPUT);
        if (elements.length > 0) {
            this.setAssignOutput(ExecJavaStep.getAttribute(elements[0], ATTR_VARNAME));
        }
        if ((elements = ExecJavaStep.getChildren(execJavaElement, ELEM_ASSIGN_ERROR)).length > 0) {
            this.setAssignError(ExecJavaStep.getAttribute(elements[0], ATTR_VARNAME));
        }
    }

    public ExecJavaStep(String className, String classPath, long timeout, VariableSettingsSource args) {
        this(className, classPath, timeout, args, null, null, null);
    }

    public ExecJavaStep(String className, String classPath, long timeout, VariableSettingsSource args, String label, String assignOutputVar, String assignErrorVar) {
        this.setClassName(className);
        this.setClassPath(classPath);
        this.setTimeout(timeout);
        this.setArgs(args);
        this.setLabel(label);
        this.setAssignOutput(assignOutputVar);
        this.setAssignError(assignErrorVar);
    }

    public String getClassName() {
        return this.mClassName;
    }

    private void setClassName(String className) {
        this.mClassName = className;
    }

    public String getClassPath() {
        return this.mClassPath;
    }

    private void setClassPath(String classPath) {
        this.mClassPath = classPath;
    }

    public String getLabel() {
        return this.mLabel;
    }

    private void setLabel(String inLabel) {
        this.mLabel = inLabel;
    }

    public String getAssignOutput() {
        return this.mAssignOutput;
    }

    private void setAssignOutput(String inAssignOutput) {
        this.mAssignOutput = inAssignOutput;
    }

    public String getAssignError() {
        return this.mAssignError;
    }

    private void setAssignError(String inAssignError) {
        this.mAssignError = inAssignError;
    }

    public long getTimeout() {
        return this.mTimeout;
    }

    private void setTimeout(long timeout) {
        this.mTimeout = timeout;
    }

    private void setTimeout(String val) {
        if (val == null) {
            this.setTimeout(Long.MIN_VALUE);
        } else {
            this.setTimeout(Long.parseLong(val));
        }
    }

    public VariableSettingsSource getArgs() {
        return (VariableSettingsSource)this.mArgs.clone();
    }

    private void setArgs(VariableSettingsSource args) {
        if (args == null) {
            this.setArgs(new ArgList());
        } else {
            this.setArgs(new ArgList(args));
        }
    }

    private void setArgs(ArgList args) {
        this.mArgs = args;
    }

    public ExecStep generate(ConfigGenerator generator) throws ConfigGenException {
        ExecJavaStep result = (ExecJavaStep)super.generate(generator);
        result.setArgs(result.mArgs.generate(generator));
        result.setClassName(generator.generate(result.getClassName()));
        result.setClassPath(generator.generate(result.getClassPath()));
        result.setLabel(generator.generate(result.getLabel()));
        return result;
    }

    protected void populateXML(XML outXML) {
        ExecJavaStep.addAttributeIfNotNull(outXML, ATTR_CLASS_NAME, this.getClassName());
        ExecJavaStep.addAttributeIfNotNull(outXML, ATTR_CLASS_PATH, this.getClassPath());
        if (this.getTimeout() != Long.MIN_VALUE) {
            ExecJavaStep.addAttributeIfNotNull(outXML, ATTR_TIMEOUT, String.valueOf(this.getTimeout()));
        }
        if (this.getLabel() != null) {
            ExecJavaStep.addAttributeIfNotNull(outXML, ATTR_LABEL, this.getLabel());
        }
        this.mArgs.writeToXML(outXML);
        if (this.getAssignOutput() != null) {
            XML assignOutput = new XML(ELEM_ASSIGN_OUTPUT);
            assignOutput.setPrettyPrint(true);
            ExecJavaStep.addAttributeIfNotNull(assignOutput, ATTR_VARNAME, this.getAssignOutput());
            outXML.addElement((org.apache.ecs.Element)assignOutput);
        }
        if (this.getAssignError() != null) {
            XML assignError = new XML(ELEM_ASSIGN_ERROR);
            assignError.setPrettyPrint(true);
            ExecJavaStep.addAttributeIfNotNull(assignError, ATTR_VARNAME, this.getAssignError());
            outXML.addElement((org.apache.ecs.Element)assignError);
        }
    }

    public String getElementName() {
        return ELEMENT_NAME;
    }

    public boolean equals(ExecStep inStep) {
        if (!(inStep instanceof ExecJavaStep)) {
            return false;
        }
        ExecJavaStep theStep = (ExecJavaStep)inStep;
        if (!ObjectUtil.equals(theStep.getClassName(), this.getClassName())) {
            return false;
        }
        if (!ObjectUtil.equals(theStep.getClassPath(), this.getClassPath())) {
            return false;
        }
        if (theStep.getTimeout() != this.getTimeout()) {
            return false;
        }
        if (!this.mArgs.equals(theStep.mArgs)) {
            return false;
        }
        if (!ObjectUtil.equals(theStep.getLabel(), this.getLabel())) {
            return false;
        }
        if (!ObjectUtil.equals(theStep.getAssignOutput(), this.getAssignOutput())) {
            return false;
        }
        return ObjectUtil.equals(theStep.getAssignError(), this.getAssignError());
    }

    void accept(PlanDBVisitor v) throws Exception {
        super.accept(v);
        v.visitToken(this.getClassName());
        v.visitToken(this.getClassPath());
        v.visit(this.mArgs);
        v.visitMutableVar(this.getAssignOutput());
        v.visitMutableVar(this.getAssignError());
    }

    ExecStep accept(PlanDBTransformer t) throws Exception {
        ExecJavaStep result = (ExecJavaStep)super.accept(t);
        result.setClassName(t.transformToken(this.getClassName()));
        result.setClassPath(t.transformToken(this.getClassPath()));
        result.mArgs = (ArgList)t.transform(this.mArgs);
        return result;
    }

    public int getStepType() {
        return 123;
    }
}

