/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.plandb;

import com.raplix.rolloutexpress.config.ConfigGenException;
import com.raplix.rolloutexpress.config.ConfigGenerator;
import com.raplix.rolloutexpress.systemmodel.XMLUtil;
import com.raplix.rolloutexpress.systemmodel.plandb.BooleanOperator;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBTransformer;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBVisitor;
import org.apache.ecs.xml.XML;
import org.w3c.dom.Element;

public class EqualsOperator
extends BooleanOperator {
    public static final String ELEMENT_NAME = "equals";
    private static final String VALUE1_ATTR = "value1";
    private static final String VALUE2_ATTR = "value2";
    private static final String EXACT_ATTR = "exact";
    private String mValue1;
    private String mValue2;
    private static final boolean DEFAULT_EXACT = false;
    private boolean mExact;

    private EqualsOperator() {
    }

    public EqualsOperator(String value1, String value2, boolean exact) {
        this.setValue1(value1);
        this.setValue2(value2);
        this.setExact(exact);
    }

    EqualsOperator(Element elem) {
        this.setValue1(XMLUtil.getAttributeEmptyAllowed(elem, VALUE1_ATTR));
        this.setValue2(XMLUtil.getAttributeEmptyAllowed(elem, VALUE2_ATTR));
        this.setExact(XMLUtil.getBooleanAttribute(elem, EXACT_ATTR));
    }

    public boolean evaluate() {
        return this.exact() ? this.getValue1().equals(this.getValue2()) : this.getValue1().equalsIgnoreCase(this.getValue2());
    }

    public String getValue1() {
        return this.mValue1;
    }

    private void setValue1(String val) {
        if (val == null) {
            throw new NullPointerException();
        }
        this.mValue1 = val;
    }

    public String getValue2() {
        return this.mValue2;
    }

    private void setValue2(String val) {
        if (val == null) {
            throw new NullPointerException();
        }
        this.mValue2 = val;
    }

    public boolean exact() {
        return this.mExact;
    }

    private void setExact(Boolean exact) {
        boolean resolvedExact = false;
        if (exact != null) {
            resolvedExact = exact;
        }
        this.setExact(resolvedExact);
    }

    private void setExact(boolean exact) {
        this.mExact = exact;
    }

    protected void populateXML(XML outXML) {
        XMLUtil.addAttributeIfNotNull(outXML, VALUE1_ATTR, this.getValue1());
        XMLUtil.addAttributeIfNotNull(outXML, VALUE2_ATTR, this.getValue2());
        if (this.exact()) {
            XMLUtil.addAttributeIfNotNull(outXML, EXACT_ATTR, String.valueOf(this.exact()));
        }
    }

    public String getElementName() {
        return ELEMENT_NAME;
    }

    protected void toString(StringBuffer outBuf) {
        this.wrapValue(outBuf, this.getValue1());
        outBuf.append(" ").append(this.getElementName());
        if (this.exact()) {
            outBuf.append(" ").append("[").append(EXACT_ATTR).append("]");
        }
        outBuf.append(" ");
        this.wrapValue(outBuf, this.getValue2());
    }

    protected boolean equalsOperator(BooleanOperator op) {
        if (!(op instanceof EqualsOperator)) {
            return false;
        }
        EqualsOperator otherOp = (EqualsOperator)op;
        return this.getValue1().equals(otherOp.getValue1()) && this.getValue2().equals(otherOp.getValue2()) && this.exact() == otherOp.exact();
    }

    public BooleanOperator generate(ConfigGenerator generator) throws ConfigGenException {
        EqualsOperator copy = (EqualsOperator)super.generate(generator);
        copy.setValue1(generator.generate(copy.getValue1()));
        copy.setValue2(generator.generate(copy.getValue2()));
        return copy;
    }

    void accept(PlanDBVisitor v) throws Exception {
        super.accept(v);
        v.visitToken(this.getValue1());
        v.visitToken(this.getValue2());
    }

    BooleanOperator accept(PlanDBTransformer t) throws Exception {
        EqualsOperator result = (EqualsOperator)super.accept(t);
        result.setValue1(t.transformToken(this.getValue1()));
        result.setValue2(t.transformToken(this.getValue2()));
        return result;
    }
}

