/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.plandb;

import com.raplix.rolloutexpress.systemmodel.XMLUtil;
import com.raplix.util.logger.Logger;
import com.raplix.util.reflect.ConstructorUtil;
import com.raplix.util.reflect.FieldUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Element;

class ElementResolver {
    private Map mElementMap = new HashMap();

    ElementResolver() {
    }

    public Object resolveChildElement(Element parentElem) {
        Element[] children = XMLUtil.getChildren(parentElem);
        for (int i = 0; i < children.length; ++i) {
            Object result = this.resolveElement(children[i]);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public Object resolveElement(Element elem) {
        String nodeName = elem.getNodeName();
        Constructor c = (Constructor)this.mElementMap.get(nodeName);
        if (c == null) {
            return null;
        }
        try {
            return ConstructorUtil.createObject(c, elem);
        }
        catch (Exception e) {
            if (Logger.isErrorEnabled(this)) {
                Logger.error("unable to create element", e, this);
            }
            return null;
        }
    }

    public void register(Class cls) {
        Field f = FieldUtil.findField(cls, "ELEMENT_NAME");
        String elementName = (String)FieldUtil.getStatic(f);
        Constructor c = ConstructorUtil.findConstructor(cls, Element.class);
        if (c == null) {
            throw new IllegalArgumentException("not an element class");
        }
        c.setAccessible(true);
        this.mElementMap.put(elementName, c);
    }
}

