/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.plandb;

import com.raplix.rolloutexpress.config.TargetedConfigContext;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.XMLUtil;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.installdb.Dependency;
import com.raplix.rolloutexpress.systemmodel.installdb.InstallDBContext;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponent;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponentID;
import com.raplix.rolloutexpress.systemmodel.plandb.Caller;
import com.raplix.rolloutexpress.systemmodel.plandb.ComponentTargeterBase;
import com.raplix.rolloutexpress.systemmodel.plandb.InstalledComponentTargeter;
import com.raplix.rolloutexpress.systemmodel.plandb.InstalledTarget;
import com.raplix.util.ObjectUtil;
import org.apache.ecs.xml.XML;
import org.w3c.dom.Element;

public class DependeeTargeter
extends ComponentTargeterBase
implements InstalledComponentTargeter {
    public static final String ELEMENT_NAME = "dependee";
    private static final String NAME_ATTR = "name";
    private String mDependeeName;

    public DependeeTargeter(String dependeeName) {
        this.setDependeeName(dependeeName);
    }

    DependeeTargeter(Element element) {
        this.setDependeeName(XMLUtil.getAttribute(element, NAME_ATTR));
    }

    private DependeeTargeter() {
    }

    public String toString() {
        return this.lookupDesc("pdb.targeter.DEPENDEE", this.getDependeeName());
    }

    public String getDependeeName() {
        return this.mDependeeName;
    }

    private void setDependeeName(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        this.mDependeeName = name;
    }

    public InstalledTarget getInstalledTarget(TargetedConfigContext ctx, Caller caller, InstallDBContext installDBCtx) throws PersistenceManagerException, RPCException {
        String name = this.getDependeeName();
        InstalledComponentID callerInstCompID = caller.getInstalledComponent().getID();
        Dependency[] deps = installDBCtx.queryDependenciesCreatedBy(callerInstCompID, name);
        InstalledComponent instComp = null;
        Component declared = null;
        if (deps.length > 0) {
            Dependency dep = deps[0];
            instComp = installDBCtx.getInstalledComponent(dep.getDependeeInstalledComponentID());
            declared = instComp.getComponentID().getByIDQuery().select();
            String typeName = dep.getDependeeDeclaredComponentExtendsTypeName();
            declared = declared.getAncestorByExtendsTypeName(typeName);
        }
        return new InstalledTarget(instComp, declared, this.getHost(instComp, ctx), caller, (ComponentTargeterBase)this);
    }

    protected String getElementName() {
        return ELEMENT_NAME;
    }

    protected void populateXML(XML outXML) {
        XMLUtil.addAttributeIfNotNull(outXML, NAME_ATTR, this.getDependeeName());
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof DependeeTargeter)) {
            return false;
        }
        DependeeTargeter targeter = (DependeeTargeter)other;
        return ObjectUtil.equals(this.getDependeeName(), targeter.getDependeeName());
    }
}

