/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.plandb;

import com.raplix.rolloutexpress.config.ConfigGenException;
import com.raplix.rolloutexpress.config.ConfigGenerator;
import com.raplix.rolloutexpress.config.TargetedConfigContext;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.XMLUtil;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentRef;
import com.raplix.rolloutexpress.systemmodel.componentdb.SingleComponentQuery;
import com.raplix.rolloutexpress.systemmodel.hostdbx.Host;
import com.raplix.rolloutexpress.systemmodel.installdb.InstallDBContext;
import com.raplix.rolloutexpress.systemmodel.plandb.Caller;
import com.raplix.rolloutexpress.systemmodel.plandb.ComponentTargeterBase;
import com.raplix.rolloutexpress.systemmodel.plandb.OverrideRepoComponentTargeter;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBTransformer;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBVisitor;
import com.raplix.rolloutexpress.systemmodel.plandb.RepoTarget;
import com.raplix.util.ObjectUtil;
import org.apache.ecs.xml.XML;
import org.w3c.dom.Element;

public class DefaultRepoTargeter
extends ComponentTargeterBase
implements OverrideRepoComponentTargeter {
    public static final String ELEMENT_NAME = "component";
    private static final String PATH_ATTR = "path";
    private static final String NAME_ATTR = "name";
    private static final String VERSION_ATTR = "version";
    private static final String HOST_ATTR = "host";
    private ComponentRef mCompRef;
    private String mHost;

    public DefaultRepoTargeter(ComponentRef ref, String host) {
        this.setComponentRef(ref);
        this.setHost(host);
    }

    DefaultRepoTargeter(Element element) {
        this.setComponentRef(this.parseComponentRef(element));
        this.setHost(XMLUtil.getAttribute(element, HOST_ATTR));
    }

    private ComponentRef parseComponentRef(Element elem) {
        String path = XMLUtil.getAttribute(elem, PATH_ATTR);
        String name = XMLUtil.getAttribute(elem, NAME_ATTR);
        String version = XMLUtil.getAttribute(elem, VERSION_ATTR);
        return new ComponentRef(path, name, version);
    }

    private DefaultRepoTargeter() {
    }

    public String toString() {
        return this.lookupDesc("pdb.targeter.DEFAULT_REPO", this.getComponentRef().getComponentFullName());
    }

    public ComponentRef getComponentRef() {
        return this.mCompRef;
    }

    private void setComponentRef(ComponentRef compRef) {
        if (compRef == null) {
            throw new NullPointerException();
        }
        this.mCompRef = compRef;
    }

    public String getHost() {
        return this.mHost;
    }

    private void setHost(String host) {
        this.mHost = host;
    }

    public ComponentRef getTargetComponentRef(Caller caller) throws PersistenceManagerException, RPCException {
        return this.getComponentRef().resolvePath(caller.getDeclaredPath());
    }

    public RepoTarget getRepoTarget(TargetedConfigContext ctx, Caller caller, InstallDBContext installDBContext) throws PersistenceManagerException, RPCException, ConfigGenException {
        ComponentRef ref = this.getTargetComponentRef(caller);
        Component comp = SingleComponentQuery.byRef(ref).select();
        return this.getRepoTarget(ctx, caller, installDBContext, comp);
    }

    public RepoTarget getRepoTarget(TargetedConfigContext ctx, Caller caller, InstallDBContext installDBContext, Component overrideComponent) throws PersistenceManagerException, RPCException, ConfigGenException {
        Host h = ctx.resolveHost(this.getHost());
        return new RepoTarget(overrideComponent, h, caller, this);
    }

    protected String getElementName() {
        return ELEMENT_NAME;
    }

    protected void populateXML(XML outXML) {
        ComponentRef compRef = this.getComponentRef();
        XMLUtil.addAttributeIfNotNull(outXML, PATH_ATTR, compRef.getPathString());
        XMLUtil.addAttributeIfNotNull(outXML, NAME_ATTR, compRef.getComponentName());
        XMLUtil.addAttributeIfNotNull(outXML, VERSION_ATTR, compRef.getComponentVersion());
        XMLUtil.addAttributeIfNotNull(outXML, HOST_ATTR, this.getHost());
    }

    public Object generate(ConfigGenerator generator) throws ConfigGenException {
        DefaultRepoTargeter copy = (DefaultRepoTargeter)this.clone();
        copy.setHost(generator.generate(copy.getHost()));
        return copy;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof DefaultRepoTargeter)) {
            return false;
        }
        DefaultRepoTargeter targeter = (DefaultRepoTargeter)other;
        return ObjectUtil.equals(this.getHost(), targeter.getHost()) && this.getComponentRef().equals(targeter.getComponentRef());
    }

    void accept(PlanDBVisitor v) throws Exception {
        super.accept(v);
        v.visit(this.getComponentRef());
        v.visitToken(this.getHost());
    }

    ComponentTargeterBase accept(PlanDBTransformer t) throws Exception {
        DefaultRepoTargeter result = (DefaultRepoTargeter)super.accept(t);
        result.setComponentRef(t.transform(this.getComponentRef()));
        result.setHost(t.transformToken(this.getHost()));
        return result;
    }
}

