/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.plandb;

import com.raplix.rolloutexpress.config.ConfigGenException;
import com.raplix.rolloutexpress.config.ConfigGenerator;
import com.raplix.rolloutexpress.config.TargetedConfigContext;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.XMLUtil;
import com.raplix.rolloutexpress.systemmodel.componentdb.Comparator;
import com.raplix.rolloutexpress.systemmodel.componentdb.InstalledComponentRef;
import com.raplix.rolloutexpress.systemmodel.installdb.InstallDBContext;
import com.raplix.rolloutexpress.systemmodel.plandb.Caller;
import com.raplix.rolloutexpress.systemmodel.plandb.ComponentTargeterBase;
import com.raplix.rolloutexpress.systemmodel.plandb.InstalledComponentTargeter;
import com.raplix.rolloutexpress.systemmodel.plandb.InstalledTarget;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBTransformer;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBVisitor;
import com.raplix.util.ObjectUtil;
import org.apache.ecs.xml.XML;
import org.w3c.dom.Element;

public class DefaultInstalledTargeter
extends ComponentTargeterBase
implements InstalledComponentTargeter {
    public static final String ELEMENT_NAME = "installedComponent";
    private static final String NAME_ATTR = "name";
    private static final String VERSION_ATTR = "version";
    private static final String VERSION_OP_ATTR = "versionOp";
    private static final String PATH_ATTR = "path";
    private static final String INSTALL_PATH_ATTR = "installPath";
    private static final String HOST_ATTR = "host";
    private static final String ONLY_COMPAT_ATTR = "onlyCompat";
    private static final Comparator DEFAULT_COMPARATOR = Comparator.GREATER_THAN_EQUAL;
    private static final boolean DEFAULT_ONLY_COMPAT = false;
    private InstalledComponentRef mCompRef;
    private String mHost;

    public DefaultInstalledTargeter(InstalledComponentRef compRef, String host) {
        this.setHost(host);
        this.setInstalledComponentRef(compRef);
    }

    DefaultInstalledTargeter(Element element) {
        this.setInstalledComponentRef(this.parseInstalledComponentRef(element));
        this.setHost(XMLUtil.getAttribute(element, HOST_ATTR));
    }

    private InstalledComponentRef parseInstalledComponentRef(Element elem) {
        String path = XMLUtil.getAttribute(elem, PATH_ATTR);
        String name = XMLUtil.getAttribute(elem, NAME_ATTR);
        String version = XMLUtil.getAttribute(elem, VERSION_ATTR);
        Comparator comp = (Comparator)XMLUtil.getEnumAttribute(elem, VERSION_OP_ATTR, Comparator.FACTORY);
        if (comp == null) {
            comp = DEFAULT_COMPARATOR;
        }
        boolean onlyCompat = XMLUtil.getBooleanAttribute(elem, ONLY_COMPAT_ATTR, false);
        String installPath = XMLUtil.getAttribute(elem, INSTALL_PATH_ATTR);
        return new InstalledComponentRef(path, name, version, comp, onlyCompat, installPath, false);
    }

    private DefaultInstalledTargeter() {
    }

    public String toString() {
        return this.lookupDesc("pdb.targeter.DEFAULT_INSTALLED", this.getInstalledComponentRef().getComponentFullName());
    }

    public InstalledComponentRef getInstalledComponentRef() {
        return this.mCompRef;
    }

    private void setInstalledComponentRef(InstalledComponentRef compRef) {
        if (compRef == null) {
            throw new NullPointerException();
        }
        this.mCompRef = compRef;
    }

    public String getHost() {
        return this.mHost;
    }

    private void setHost(String host) {
        this.mHost = host;
    }

    public InstalledTarget getInstalledTarget(TargetedConfigContext ctx, Caller caller, InstallDBContext installDBContext) throws PersistenceManagerException, RPCException, ConfigGenException {
        return this.getInstalledTarget(this.getInstalledComponentRef(), this.getHost(), ctx, caller, installDBContext);
    }

    protected String getElementName() {
        return ELEMENT_NAME;
    }

    protected void populateXML(XML outXML) {
        InstalledComponentRef compRef = this.getInstalledComponentRef();
        XMLUtil.addAttributeIfNotNull(outXML, PATH_ATTR, compRef.getPathString());
        XMLUtil.addAttributeIfNotNull(outXML, NAME_ATTR, compRef.getComponentName());
        XMLUtil.addAttributeIfNotNull(outXML, VERSION_ATTR, compRef.getComponentVersion());
        Comparator comp = compRef.getVersionComparator();
        if (!DEFAULT_COMPARATOR.equals(comp)) {
            XMLUtil.addAttributeIfNotNull(outXML, VERSION_OP_ATTR, comp.toString());
        }
        XMLUtil.addAttribute(outXML, ONLY_COMPAT_ATTR, compRef.getOnlyCallCompatible(), false);
        XMLUtil.addAttributeIfNotNull(outXML, INSTALL_PATH_ATTR, compRef.getInstallPath());
        XMLUtil.addAttributeIfNotNull(outXML, HOST_ATTR, this.getHost());
    }

    public Object generate(ConfigGenerator generator) throws ConfigGenException {
        DefaultInstalledTargeter copy = (DefaultInstalledTargeter)this.clone();
        copy.setHost(generator.generate(copy.getHost()));
        InstalledComponentRef icr = copy.getInstalledComponentRef();
        icr = icr.generate(generator);
        copy.setInstalledComponentRef(icr);
        return copy;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof DefaultInstalledTargeter)) {
            return false;
        }
        DefaultInstalledTargeter targeter = (DefaultInstalledTargeter)other;
        return ObjectUtil.equals(this.getHost(), targeter.getHost()) && this.getInstalledComponentRef().equals(targeter.getInstalledComponentRef());
    }

    void accept(PlanDBVisitor v) throws Exception {
        super.accept(v);
        v.visit(this.getInstalledComponentRef());
        v.visitToken(this.getHost());
    }

    ComponentTargeterBase accept(PlanDBTransformer t) throws Exception {
        DefaultInstalledTargeter result = (DefaultInstalledTargeter)super.accept(t);
        result.setInstalledComponentRef((InstalledComponentRef)t.transform(this.getInstalledComponentRef()));
        result.setHost(t.transformToken(this.getHost()));
        return result;
    }
}

