/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.plandb;

import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.plandb.Caller;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecStep;
import com.raplix.rolloutexpress.systemmodel.plandb.InstallBlockStep;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBException;
import com.raplix.rolloutexpress.systemmodel.plandb.TargetVariableStep;
import com.raplix.util.ObjectUtil;
import org.apache.ecs.xml.XML;
import org.w3c.dom.Element;

public class CreateSnapshotStep
extends ExecStep
implements InstallBlockStep,
TargetVariableStep {
    public static final String ELEMENT_NAME = "createSnapshot";
    private static final String ATTR_BLOCK_NAME = "blockName";
    private String mBlockName;

    private CreateSnapshotStep() {
    }

    public CreateSnapshotStep(Element stepElement) {
        super(stepElement);
        this.setBlockName(CreateSnapshotStep.getAttribute(stepElement, ATTR_BLOCK_NAME));
    }

    public CreateSnapshotStep(String blockName) {
        this.setBlockName(blockName);
    }

    public String getBlockName() {
        return this.mBlockName;
    }

    private void setBlockName(String blockName) {
        this.mBlockName = blockName;
    }

    protected void populateXML(XML outXML) {
        CreateSnapshotStep.addAttributeIfNotNull(outXML, ATTR_BLOCK_NAME, this.getBlockName());
    }

    public void validate(Caller container) throws PlanDBException {
        Component comp = container.getDeclaredComponent();
        if (comp == null || comp.resolveSnapshotBlock(this.getBlockName(), null) == null) {
            throw PlanDBException.invalidCreateSnapshot(this.getBlockName());
        }
    }

    public String getElementName() {
        return ELEMENT_NAME;
    }

    public boolean equals(ExecStep inStep) {
        if (!(inStep instanceof CreateSnapshotStep)) {
            return false;
        }
        CreateSnapshotStep theStep = (CreateSnapshotStep)inStep;
        return ObjectUtil.equals(this.getBlockName(), theStep.getBlockName());
    }

    public int getStepType() {
        return 116;
    }
}

