/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.plandb;

import com.raplix.rolloutexpress.config.ConfigGenException;
import com.raplix.rolloutexpress.config.ConfigGenerator;
import com.raplix.rolloutexpress.systemmodel.plandb.Caller;
import com.raplix.rolloutexpress.systemmodel.plandb.ComponentTargeterFactory;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecStep;
import com.raplix.rolloutexpress.systemmodel.plandb.InstallBlockStep;
import com.raplix.rolloutexpress.systemmodel.plandb.InstalledComponentTargeter;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBException;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBTransformer;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBVisitor;
import org.apache.ecs.xml.XML;
import org.w3c.dom.Element;

public class CreateDependencyStep
extends ExecStep
implements InstallBlockStep {
    public static final String ELEMENT_NAME = "createDependency";
    private static final String NAME_ATTR = "name";
    private String mName;
    private InstalledComponentTargeter mTargeter;

    private CreateDependencyStep() {
    }

    public CreateDependencyStep(Element elem) {
        super(elem);
        this.setName(CreateDependencyStep.getAttribute(elem, NAME_ATTR));
        this.setTargeter(ComponentTargeterFactory.getInstalledTargeter(elem));
    }

    public CreateDependencyStep(String name, InstalledComponentTargeter targeter) {
        this.setName(name);
        this.setTargeter(targeter);
    }

    public String getName() {
        return this.mName;
    }

    private void setName(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        this.mName = name;
    }

    public InstalledComponentTargeter getTargeter() {
        return this.mTargeter;
    }

    private void setTargeter(InstalledComponentTargeter targeter) {
        if (targeter == null) {
            throw new NullPointerException();
        }
        this.mTargeter = targeter;
    }

    protected void populateXML(XML outXML) {
        CreateDependencyStep.addAttributeIfNotNull(outXML, NAME_ATTR, this.getName());
        outXML.addElement((org.apache.ecs.Element)this.getTargeter().writeToXML());
    }

    public void validate(Caller container) throws PlanDBException {
        this.getTargeter().validate(container);
    }

    public String getElementName() {
        return ELEMENT_NAME;
    }

    public boolean equals(ExecStep inStep) {
        if (!(inStep instanceof CreateDependencyStep)) {
            return false;
        }
        CreateDependencyStep theStep = (CreateDependencyStep)inStep;
        if (!this.equals(theStep.getName(), this.getName())) {
            return false;
        }
        return this.equals(theStep.getTargeter(), this.getTargeter());
    }

    public int getStepType() {
        return 113;
    }

    public ExecStep generate(ConfigGenerator generator) throws ConfigGenException {
        CreateDependencyStep copy = (CreateDependencyStep)super.generate(generator);
        copy.setTargeter((InstalledComponentTargeter)copy.mTargeter.generate(generator));
        return copy;
    }

    void accept(PlanDBVisitor v) throws Exception {
        super.accept(v);
        v.visit(this.getTargeter());
    }

    ExecStep accept(PlanDBTransformer t) throws Exception {
        CreateDependencyStep result = (CreateDependencyStep)super.accept(t);
        result.setTargeter(t.transform(this.getTargeter()));
        return result;
    }
}

