/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.plandb;

import com.raplix.rolloutexpress.config.TargetedConfigContext;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentRefDecl;
import com.raplix.rolloutexpress.systemmodel.installdb.InstallDBContext;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponent;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponentID;
import com.raplix.rolloutexpress.systemmodel.plandb.Caller;
import com.raplix.rolloutexpress.systemmodel.plandb.ComponentTargeterBase;
import com.raplix.rolloutexpress.systemmodel.plandb.InstalledComponentTargeter;
import com.raplix.rolloutexpress.systemmodel.plandb.InstalledTarget;
import org.w3c.dom.Element;

public class ContainerTargeter
extends ComponentTargeterBase
implements InstalledComponentTargeter {
    public static final String ELEMENT_NAME = "container";

    public ContainerTargeter() {
    }

    ContainerTargeter(Element element) {
    }

    public String toString() {
        return this.lookupDesc("pdb.targeter.CONTAINER");
    }

    public InstalledTarget getInstalledTarget(TargetedConfigContext ctx, Caller caller, InstallDBContext idbCtx) throws PersistenceManagerException, RPCException {
        InstalledComponentID containerID;
        InstalledComponent current = caller.getInstalledComponent();
        InstalledComponent container = null;
        Component refDeclarer = null;
        if (current != null && (containerID = current.getParentContainerID()) != null && (container = idbCtx.getInstalledComponent(containerID)) != null) {
            Component containerComp = container.getComponentID().getByIDQuery().select();
            String refName = current.getParentContainerRefName();
            ComponentRefDecl ref = containerComp.resolveCompRef(refName, null);
            refDeclarer = ref.getDeclaringComponent();
        }
        return new InstalledTarget(container, refDeclarer, this.getHost(container, ctx), caller, (ComponentTargeterBase)this);
    }

    protected String getElementName() {
        return ELEMENT_NAME;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        return other instanceof ContainerTargeter;
    }
}

