/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.plandb;

import com.raplix.rolloutexpress.systemmodel.SystemModelParseException;
import com.raplix.rolloutexpress.systemmodel.XMLUtil;
import com.raplix.rolloutexpress.systemmodel.plandb.AllDependantsTargeter;
import com.raplix.rolloutexpress.systemmodel.plandb.AllNestedRefsTargeter;
import com.raplix.rolloutexpress.systemmodel.plandb.DefaultInstalledTargeter;
import com.raplix.rolloutexpress.systemmodel.plandb.DefaultRepoTargeter;
import com.raplix.rolloutexpress.systemmodel.plandb.DependeeTargeter;
import com.raplix.rolloutexpress.systemmodel.plandb.ElementResolver;
import com.raplix.rolloutexpress.systemmodel.plandb.InstalledComponentTargeter;
import com.raplix.rolloutexpress.systemmodel.plandb.NestedRefTargeter;
import com.raplix.rolloutexpress.systemmodel.plandb.RepoComponentTargeter;
import com.raplix.rolloutexpress.systemmodel.plandb.SuperTargeter;
import com.raplix.rolloutexpress.systemmodel.plandb.SystemServiceTargeter;
import com.raplix.rolloutexpress.systemmodel.plandb.SystemTypeTargeter;
import com.raplix.rolloutexpress.systemmodel.plandb.TargetableComponentTargeter;
import com.raplix.rolloutexpress.systemmodel.plandb.ThisTargeter;
import com.raplix.rolloutexpress.systemmodel.plandb.TopLevelRefTargeter;
import java.io.IOException;
import java.io.StringReader;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ComponentTargeterFactory {
    private static final ElementResolver REPO_TARGETERS = new ElementResolver();
    private static final ElementResolver INSTALLED_TARGETERS;

    public static RepoComponentTargeter getRepoTargeter(String content) throws SystemModelParseException {
        return (RepoComponentTargeter)REPO_TARGETERS.resolveElement(ComponentTargeterFactory.parseContent(content));
    }

    public static RepoComponentTargeter getRepoTargeter(Element content) {
        return (RepoComponentTargeter)REPO_TARGETERS.resolveChildElement(content);
    }

    public static InstalledComponentTargeter getInstalledTargeter(String content) throws SystemModelParseException {
        return (InstalledComponentTargeter)INSTALLED_TARGETERS.resolveElement(ComponentTargeterFactory.parseContent(content));
    }

    public static InstalledComponentTargeter getInstalledTargeter(Element content) {
        return (InstalledComponentTargeter)INSTALLED_TARGETERS.resolveChildElement(content);
    }

    private static Element parseContent(String content) throws SystemModelParseException {
        DOMParser parser = XMLUtil.obtainParser(false, null, null);
        InputSource in = new InputSource(new StringReader(content));
        try {
            parser.parse(in);
            return parser.getDocument().getDocumentElement();
        }
        catch (IOException e) {
            throw ComponentTargeterFactory.newParseError(e);
        }
        catch (SAXException e) {
            throw ComponentTargeterFactory.newParseError(e);
        }
    }

    private static SystemModelParseException newParseError(Exception e) {
        return new SystemModelParseException(e, "pdb.");
    }

    static {
        REPO_TARGETERS.register(DefaultRepoTargeter.class);
        REPO_TARGETERS.register(ThisTargeter.class);
        REPO_TARGETERS.register(NestedRefTargeter.class);
        REPO_TARGETERS.register(AllNestedRefsTargeter.class);
        REPO_TARGETERS.register(TopLevelRefTargeter.class);
        REPO_TARGETERS.register(SuperTargeter.class);
        INSTALLED_TARGETERS = new ElementResolver();
        INSTALLED_TARGETERS.register(DefaultInstalledTargeter.class);
        INSTALLED_TARGETERS.register(SystemServiceTargeter.class);
        INSTALLED_TARGETERS.register(ThisTargeter.class);
        INSTALLED_TARGETERS.register(NestedRefTargeter.class);
        INSTALLED_TARGETERS.register(AllNestedRefsTargeter.class);
        INSTALLED_TARGETERS.register(TopLevelRefTargeter.class);
        INSTALLED_TARGETERS.register(SuperTargeter.class);
        INSTALLED_TARGETERS.register(SystemTypeTargeter.class);
        INSTALLED_TARGETERS.register(DependeeTargeter.class);
        INSTALLED_TARGETERS.register(AllDependantsTargeter.class);
        INSTALLED_TARGETERS.register(TargetableComponentTargeter.class);
    }
}

