/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.systemmodel.plandb;

import com.raplix.rolloutexpress.config.ConfigGenException;
import com.raplix.rolloutexpress.config.ConfigGenerator;
import com.raplix.rolloutexpress.config.TargetedConfigContext;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.componentdb.CallSpec;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentID;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentRefDecl;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentType;
import com.raplix.rolloutexpress.systemmodel.componentdb.InstallMode;
import com.raplix.rolloutexpress.systemmodel.componentdb.InstalledComponentRef;
import com.raplix.rolloutexpress.systemmodel.hostdbx.Host;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.installdb.InstallDBContext;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponent;
import com.raplix.rolloutexpress.systemmodel.plandb.Caller;
import com.raplix.rolloutexpress.systemmodel.plandb.InstalledTarget;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBException;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBPluginNSValidator;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBTransformer;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanDBVisitor;
import com.raplix.rolloutexpress.systemmodel.plandb.RepoTarget;
import org.apache.ecs.xml.XML;

abstract class ComponentTargeterBase
implements Cloneable {
    protected ComponentTargeterBase() {
    }

    public boolean isBulkTargeter() {
        return false;
    }

    public abstract String toString();

    public boolean isInternalTarget() {
        return false;
    }

    public RepoTarget getRepoTarget(TargetedConfigContext ctx, Caller caller, InstallDBContext installDBContext) throws PersistenceManagerException, RPCException, ConfigGenException {
        return null;
    }

    public RepoTarget[] getAllRepoTargets(TargetedConfigContext ctx, Caller caller, InstallDBContext installDBContext) throws PersistenceManagerException, RPCException, ConfigGenException {
        return null;
    }

    InstalledTarget getInstalledTarget(InstalledComponentRef icr, String hostRef, TargetedConfigContext ctx, Caller caller, InstallDBContext installDBContext) throws PersistenceManagerException, RPCException, ConfigGenException {
        return this.getInstalledTarget(icr, null, hostRef, ctx, caller, installDBContext);
    }

    InstalledTarget getInstalledTarget(InstalledComponentRef icr, Component declared, String hostRef, TargetedConfigContext ctx, Caller caller, InstallDBContext installDBContext) throws PersistenceManagerException, RPCException, ConfigGenException {
        Host h = ctx.resolveHost(hostRef);
        icr = (InstalledComponentRef)icr.resolvePath(caller.getDeclaredPath());
        InstalledComponent instComp = installDBContext.getInstalledComponent(h.getID(), icr);
        return new InstalledTarget(instComp, declared, h, caller, this);
    }

    Host getHost(InstalledComponent instComp, TargetedConfigContext ctx) throws PersistenceManagerException, RPCException {
        if (instComp == null) {
            return null;
        }
        HostID hostID = instComp.getTargetID().getByIDQuery().selectSummaryView().getCurrentHostID();
        return ctx.getHost(hostID);
    }

    ComponentRefDecl resolveRef(Caller caller, String refName, InstallMode installMode) throws PlanDBException {
        CallSpec cs = caller.getDeclaredComponent().getThisCallSpec();
        Component comp = caller.getActualComponent();
        ComponentRefDecl ref = comp.resolveCompRef(refName, cs);
        if (ref == null) {
            throw PlanDBException.noSuchCompRef(comp, refName);
        }
        if (!installMode.equals(ref.getInstallMode())) {
            throw PlanDBException.invalidCompRefInstallMode(comp, refName, installMode);
        }
        return ref;
    }

    Component getDeclaredTypeOfRef(ComponentRefDecl compRef, Caller caller) {
        Component declarer = caller.getDeclaredComponent();
        compRef = declarer.resolveCompRef(compRef.getName(), null);
        if (compRef == null) {
            return declarer.getCompRefListType().getComponent();
        }
        ComponentID refDeclarerID = compRef.getDeclaringComponent().getID();
        while (!declarer.getID().equals(refDeclarerID)) {
            ComponentType localListType = declarer.getLocalCompRefListType();
            if (localListType != null) {
                return localListType.getComponent();
            }
            declarer = declarer.getExtendsType().getComponent();
        }
        return compRef.getType().getComponent();
    }

    public InstalledTarget getInstalledTarget(TargetedConfigContext ctx, Caller caller, InstallDBContext installDBContext) throws PersistenceManagerException, RPCException, ConfigGenException {
        return null;
    }

    public InstalledTarget[] getAllInstalledTargets(TargetedConfigContext ctx, Caller caller, InstallDBContext installDBContext) throws PersistenceManagerException, RPCException, ConfigGenException {
        return null;
    }

    public XML writeToXML() {
        XML result = new XML(this.getElementName());
        result.setPrettyPrint(true);
        this.populateXML(result);
        return result;
    }

    protected void populateXML(XML outXML) {
    }

    protected abstract String getElementName();

    public String writeToString() {
        return this.writeToXML().toString();
    }

    public Object generate(ConfigGenerator generator) throws ConfigGenException {
        return this;
    }

    protected Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public abstract boolean equals(Object var1);

    public void validate(Caller container) throws PlanDBException {
    }

    protected String lookupDesc(String code) {
        return this.lookupDesc(code, new Object[0]);
    }

    protected String lookupDesc(String code, String arg) {
        return this.lookupDesc(code, new Object[]{arg});
    }

    private String lookupDesc(String code, Object[] args) {
        return new ROXMessage(code, args).toString();
    }

    CallSpec getCallSpec(Caller caller, Component declaredComp) {
        return new CallSpec(caller, declaredComp.getID());
    }

    void accept(PlanDBVisitor v) throws Exception {
    }

    ComponentTargeterBase accept(PlanDBTransformer t) throws Exception {
        return t.clone(this);
    }

    ComponentTargeterBase cloneForTransform() {
        return (ComponentTargeterBase)this.clone();
    }

    void validateNamespace(PlanDBPluginNSValidator v) throws Exception {
        this.accept(v);
    }
}

